/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import aurocosh.divinefavor.common.lib.math.Vector2i;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007J8\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001a\u001a\u00020\u0007J$\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001a\u001a\u00020\u0013JD\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!\u00a8\u0006%"}, d2={"Laurocosh/divinefavor/common/util/UtilGui;", "", "()V", "drawPolyline", "", "points", "", "Laurocosh/divinefavor/common/lib/math/Vector2i;", "red", "", "green", "blue", "alpha", "drawTexture", "mc", "Lnet/minecraft/client/Minecraft;", "location", "Lnet/minecraft/util/ResourceLocation;", "x", "", "y", "width", "height", "findClosestPoint", "target", "", "defaultValue", "findClosestPointIndex", "generateSpiral", "pointCount", "pointsToSkip", "scalar", "a", "", "aChange", "xScale", "yScale", "divinefavor"})
public final class UtilGui {
    public static final UtilGui INSTANCE;

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public final void drawPolyline(@NotNull List<Vector2i> points, float red, float green, float blue, float alpha) {
        Intrinsics.checkParameterIsNotNull(points, (String)"points");
        GL11.glDisable((int)3553);
        GlStateManager.func_179097_i();
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)3);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void x;
            void i;
            Vector2i vector2i = points.get((int)i);
            int n3 = vector2i.component1();
            int y = vector2i.component2();
            GlStateManager.func_187435_e((float)((float)x), (float)y, (float)150.0f);
            ++i;
        }
        GL11.glEnd();
        GlStateManager.func_179126_j();
        GL11.glEnable((int)3553);
    }

    @NotNull
    public final Vector2i findClosestPoint(@NotNull Vector2i target, @NotNull Collection<Vector2i> points, @NotNull Vector2i defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(points, (String)"points");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        Vector2i result = defaultValue;
        int maxDistanceSq = Integer.MAX_VALUE;
        for (Vector2i point : points) {
            int distanceSq = target.subtract(point).magnitudeSquare();
            if (distanceSq >= maxDistanceSq) continue;
            maxDistanceSq = distanceSq;
            result = point;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final int findClosestPointIndex(@NotNull Vector2i target, @NotNull List<Vector2i> points, int defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull(points, (String)"points");
        int result = defaultValue;
        int maxDistanceSq = Integer.MAX_VALUE;
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void i;
            int distanceSq = target.subtract(points.get((int)i)).magnitudeSquare();
            if (distanceSq < maxDistanceSq) {
                maxDistanceSq = distanceSq;
                result = i;
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2i> generateSpiral(int pointCount, int pointsToSkip, int scalar, double a, double aChange, double xScale, double yScale) {
        double aVar = a;
        ArrayList<Vector2i> points = new ArrayList<Vector2i>(pointCount);
        int n = 0;
        int n2 = pointCount;
        while (n < n2) {
            void i;
            double lni1 = Math.log(aVar * (double)scalar * (double)(i + pointsToSkip)) / aVar;
            double logSpiral = Math.exp(lni1 * aVar);
            double pointX = xScale * logSpiral * Math.cos(lni1);
            double pointY = yScale * logSpiral * Math.sin(lni1);
            points.add(new Vector2i((int)pointX, (int)pointY));
            aVar += aChange;
            ++i;
        }
        return points;
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawTexture(@NotNull Minecraft mc, @NotNull ResourceLocation location, int x, int y, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        mc.func_110434_K().func_110577_a(location);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (float)width, (float)height);
    }

    private UtilGui() {
    }

    static {
        UtilGui utilGui;
        INSTANCE = utilGui = new UtilGui();
    }
}

