/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import aurocosh.divinefavor.common.lib.GlobalBlockPos;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0014\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Laurocosh/divinefavor/common/util/UtilSerialize;", "", "()V", "deserializeGlobalBlockPosArray", "Ljava/util/ArrayList;", "Laurocosh/divinefavor/common/lib/GlobalBlockPos;", "Lkotlin/collections/ArrayList;", "array", "", "getPasteStream", "Ljava/io/ByteArrayOutputStream;", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "joinByteArrays", "", "arrays", "", "serializeGlobalBlockPosArray", "posArrayList", "splitArray", "arrayToSplit", "chunkSize", "", "stringToUUID", "Ljava/util/UUID;", "string", "", "divinefavor"})
public final class UtilSerialize {
    public static final UtilSerialize INSTANCE;

    @NotNull
    public final int[] serializeGlobalBlockPosArray(@NotNull List<GlobalBlockPos> posArrayList) {
        Intrinsics.checkParameterIsNotNull(posArrayList, (String)"posArrayList");
        int[] array = new int[posArrayList.size() * 4];
        int i = 0;
        for (GlobalBlockPos globalBlockPos : posArrayList) {
            BlockPos pos2 = globalBlockPos.component1();
            int dimensionId = globalBlockPos.component2();
            array[i++] = pos2.func_177958_n();
            array[i++] = pos2.func_177956_o();
            array[i++] = pos2.func_177952_p();
            array[i++] = dimensionId;
        }
        return array;
    }

    @NotNull
    public final ArrayList<GlobalBlockPos> deserializeGlobalBlockPosArray(@NotNull int[] array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        int posCount = array.length / 4;
        ArrayList<GlobalBlockPos> posArrayList = new ArrayList<GlobalBlockPos>();
        int j = 0;
        for (int i = 0; i < posCount; ++i) {
            int x = array[j++];
            int y = array[j++];
            int z = array[j++];
            int dimension = array[j++];
            posArrayList.add(new GlobalBlockPos(x, y, z, dimension));
        }
        return posArrayList;
    }

    @Nullable
    public final UUID stringToUUID(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public final ByteArrayOutputStream getPasteStream(@NotNull NBTTagCompound compound) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)outputStream);
        return outputStream.size() < 32567 ? outputStream : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<byte[]> splitArray(@NotNull byte[] arrayToSplit, int chunkSize) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)arrayToSplit, (String)"arrayToSplit");
        if (chunkSize <= 0) {
            return CollectionsKt.emptyList();
        }
        int rest = arrayToSplit.length % chunkSize;
        int chunks = arrayToSplit.length / chunkSize + (rest > 0 ? 1 : 0);
        ArrayList<byte[]> arrays = new ArrayList<byte[]>(chunks);
        int n2 = 0;
        int n3 = n = rest > 0 ? chunks - 1 : chunks;
        while (n2 < n) {
            void i;
            byte[] chunk = Arrays.copyOfRange(arrayToSplit, (int)(i * chunkSize), (int)(i * chunkSize + chunkSize));
            arrays.add(chunk);
            ++i;
        }
        if (rest > 0) {
            byte[] chunk = Arrays.copyOfRange(arrayToSplit, (chunks - 1) * chunkSize, (chunks - 1) * chunkSize + rest);
            arrays.add(chunk);
        }
        return arrays;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] joinByteArrays(@NotNull List<byte[]> arrays) {
        Intrinsics.checkParameterIsNotNull(arrays, (String)"arrays");
        if (arrays.isEmpty()) {
            return new byte[0];
        }
        byte[] firstArray = (byte[])CollectionsKt.first(arrays);
        if (arrays.size() == 1) {
            byte[] byArray = firstArray;
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
            return byArray2;
        }
        Iterable $receiver$iv = arrays;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void receiver;
            Object t = element$iv;
            int n = sum$iv;
            int n2 = ((byte[])receiver).getSize();
            sum$iv = n + n2;
        }
        int finalSize = sum$iv;
        List<byte[]> otherArrays = arrays.subList(1, arrays.size() - 1);
        Object object = firstArray;
        byte[] byArray = Arrays.copyOf((byte[])object, finalSize);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] finalArray = byArray;
        int nextIndexStart = firstArray.length;
        for (byte[] array : otherArrays) {
            System.arraycopy(array, 0, finalArray, nextIndexStart, array.length);
            nextIndexStart += array.length;
        }
        return finalArray;
    }

    private UtilSerialize() {
    }

    static {
        UtilSerialize utilSerialize;
        INSTANCE = utilSerialize = new UtilSerialize();
    }
}

