/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Laurocosh/divinefavor/common/util/UtilWorld;", "", "()V", "getLightLevel", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getPlayerList", "Lnet/minecraft/server/management/PlayerList;", "raycast", "Lnet/minecraft/util/math/RayTraceResult;", "origin", "Lnet/minecraft/util/math/Vec3d;", "ray", "length", "", "divinefavor"})
public final class UtilWorld {
    public static final UtilWorld INSTANCE;

    @Nullable
    public final RayTraceResult raycast(@NotNull World world, @NotNull Vec3d origin, @NotNull Vec3d ray, double length) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        Intrinsics.checkParameterIsNotNull((Object)ray, (String)"ray");
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(length));
        return world.func_72933_a(origin, end);
    }

    @NotNull
    public final PlayerList getPlayerList(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        MinecraftServer minecraftServer = world.func_73046_m();
        if (minecraftServer == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"world.minecraftServer!!");
        PlayerList playerList = minecraftServer.func_184103_al();
        Intrinsics.checkExpressionValueIsNotNull((Object)playerList, (String)"world.minecraftServer!!.playerList");
        return playerList;
    }

    public final int getLightLevel(@NotNull World world, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        int skyLightSub = world.func_72967_a(1.0f);
        int lightBlock = world.func_175642_b(EnumSkyBlock.BLOCK, pos2);
        int lightSky = world.func_175642_b(EnumSkyBlock.SKY, pos2) - skyLightSub;
        return Math.max(lightBlock, lightSky);
    }

    private UtilWorld() {
    }

    static {
        UtilWorld utilWorld;
        INSTANCE = utilWorld = new UtilWorld();
    }
}

