/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventorySimple;
import com.brandon3055.brandonscore.command.BCUtilCommands;
import com.brandon3055.brandonscore.network.PacketDispatcher;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPlayerAccess
extends Container {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public EntityPlayer player;
    public EntityPlayer playerAccess;
    private IInventory targetInventory;
    private MinecraftServer server;
    private int tick = 0;

    public ContainerPlayerAccess(EntityPlayer player) {
        this.player = player;
        this.playerAccess = null;
        this.targetInventory = new InventorySimple(41);
        this.layoutSlots();
    }

    public ContainerPlayerAccess(EntityPlayer player, EntityPlayer playerAccess, MinecraftServer server) {
        this.player = player;
        this.playerAccess = playerAccess;
        this.targetInventory = playerAccess.field_71071_by;
        this.server = server;
        this.layoutSlots();
    }

    @SideOnly(value=Side.SERVER)
    public void func_75142_b() {
        if (this.playerAccess != null && !(this.playerAccess instanceof BCUtilCommands.OfflinePlayer)) {
            if (this.playerAccess.field_70128_L) {
                this.player.func_71053_j();
                this.player.func_145747_a(new TextComponentString("Target player died or disconnected.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)).func_150257_a(new TextComponentString("\n(run command again to re-establish inventory connection)").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))));
                return;
            }
        } else if (this.playerAccess != null && this.server.func_184103_al().func_177451_a(this.playerAccess.func_146103_bH().getId()) != null) {
            this.player.func_71053_j();
            this.player.func_145747_a(new TextComponentString("Target player is now online.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)).func_150257_a(new TextComponentString("\n(run command again to re-establish inventory connection)").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))));
            return;
        }
        if (this.tick++ % 10 == 0 && this.player instanceof EntityPlayerMP && this.playerAccess != null) {
            PacketDispatcher.sendPlayerAccessUIUpdate((EntityPlayerMP)this.player, this.playerAccess);
        }
        super.func_75142_b();
    }

    public void layoutSlots() {
        int i;
        int x;
        int y;
        int x2;
        int xPos = 9;
        int yPos = 21;
        for (x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(this.targetInventory, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(this.targetInventory, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new ArmorSlot(this.targetInventory, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.func_75146_a(new OffhandSlot(this.targetInventory, 40, xPos + 186, yPos + 54 + 3));
        xPos = 9;
        yPos = 168;
        for (x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new ArmorSlot((IInventory)this.player.field_71071_by, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.func_75146_a(new OffhandSlot((IInventory)this.player.field_71071_by, 40, xPos + 186, yPos + 54 + 3));
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    private static class OffhandSlot
    extends Slot {
        public OffhandSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public String func_178171_c() {
            return "minecraft:items/empty_armor_slot_shield";
        }
    }

    private static class ArmorSlot
    extends Slot {
        private final EntityEquipmentSlot eSlot;
        private final EntityPlayer aPlayer;

        public ArmorSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, EntityEquipmentSlot eSlot, EntityPlayer aPlayer) {
            super(inventoryIn, index, xPosition, yPosition);
            this.eSlot = eSlot;
            this.aPlayer = aPlayer;
        }

        public int func_75219_a() {
            return 64;
        }

        public boolean func_75214_a(ItemStack stack) {
            return true;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            ItemStack itemstack = this.func_75211_c();
            return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public String func_178171_c() {
            return ItemArmor.field_94603_a[this.eSlot.func_188454_b()];
        }
    }
}

