/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_12_2;

import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.dynmap.Log;
import org.dynmap.forge_1_12_2.DynmapPlugin;
import org.dynmap.renderer.DynmapBlockState;

public class ChunkSnapshot {
    private final int x;
    private final int z;
    private final Section[] section;
    private final int[] hmap;
    private final int[] biome;
    private final long captureFulltime;
    private final int sectionCnt;
    private final long inhabitedTicks;
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int COLUMNS_PER_CHUNK = 256;
    private static final byte[] emptyData = new byte[2048];
    private static final byte[] fullData = new byte[2048];
    private static final EmptySection empty_section;

    public ChunkSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
        this.x = x;
        this.z = z;
        this.captureFulltime = captime;
        this.biome = new int[256];
        this.sectionCnt = worldheight / 16;
        this.section = new Section[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.section[i] = empty_section;
        }
        this.hmap = new int[256];
        this.inhabitedTicks = inhabitedTime;
    }

    public ChunkSnapshot(NBTTagCompound nbt, int worldheight) {
        block18: {
            block19: {
                this.x = nbt.func_74762_e("xPos");
                this.z = nbt.func_74762_e("zPos");
                this.captureFulltime = 0L;
                this.hmap = nbt.func_74759_k("HeightMap");
                this.sectionCnt = worldheight / 16;
                this.inhabitedTicks = nbt.func_74764_b("InhabitedTime") ? nbt.func_74763_f("InhabitedTime") : 0L;
                this.section = new Section[this.sectionCnt];
                for (int i = 0; i < this.sectionCnt; ++i) {
                    this.section[i] = empty_section;
                }
                NBTTagList sect = nbt.func_150295_c("Sections", 10);
                for (int i = 0; i < sect.func_74745_c(); ++i) {
                    NBTTagCompound sec = sect.func_150305_b(i);
                    byte secnum = sec.func_74771_c("Y");
                    if (secnum >= this.sectionCnt) {
                        Log.info("Section " + secnum + " above world height " + worldheight);
                        continue;
                    }
                    StdSection cursect = new StdSection();
                    this.section[secnum] = cursect;
                    DynmapBlockState[] states = cursect.states;
                    if (sec.func_150297_b("Palette", 11)) {
                        int[] p = sec.func_74759_k("Palette");
                        byte[] msb_bytes = sec.func_74770_j("Blocks");
                        int mlen = msb_bytes.length / 2;
                        int llen = 2048;
                        byte[] lsb_bytes = sec.func_74770_j("Data");
                        if (llen > lsb_bytes.length) {
                            llen = lsb_bytes.length;
                        }
                        for (int j = 0; j < llen; ++j) {
                            int idx = lsb_bytes[j] & 0xF;
                            int idx2 = (lsb_bytes[j] & 0xF0) >>> 4;
                            if (j < mlen) {
                                idx += (0xFF & msb_bytes[2 * j]) << 4;
                                idx2 += (0xFF & msb_bytes[2 * j + 1]) << 4;
                            }
                            states[2 * j] = DynmapPlugin.stateByID[idx < p.length ? p[idx] : 0];
                            states[2 * j + 1] = DynmapPlugin.stateByID[idx2 < p.length ? p[idx2] : 0];
                        }
                    } else {
                        byte[] lsb_bytes = sec.func_74770_j("Blocks");
                        if (lsb_bytes.length < 4096) {
                            lsb_bytes = Arrays.copyOf(lsb_bytes, 4096);
                        }
                        byte[] addid = null;
                        if (sec.func_150297_b("Add", 7) && (addid = sec.func_74770_j("Add")).length < 2048) {
                            addid = Arrays.copyOf(addid, 2048);
                        }
                        byte[] addid2 = null;
                        if (sec.func_150297_b("Add2", 7) && (addid2 = sec.func_74770_j("Add2")).length < 2048) {
                            addid2 = Arrays.copyOf(addid2, 2048);
                        }
                        byte[] bd = null;
                        if (sec.func_150297_b("Data", 7) && (bd = sec.func_74770_j("Data")).length < 2048) {
                            bd = Arrays.copyOf(bd, 2048);
                        }
                        for (int j = 0; j < 4096; j += 2) {
                            byte b;
                            int id = (0xFF & lsb_bytes[j]) << 4;
                            int id2 = (0xFF & lsb_bytes[j + 1]) << 4;
                            if (addid != null) {
                                b = addid[j >> 1];
                                id += (0xF & b) << 12;
                                id2 += (0xF0 & b) << 8;
                            }
                            if (addid2 != null) {
                                b = addid2[j >> 1];
                                id += (0xF & b) << 16;
                                id2 += (0xF0 & b) << 12;
                            }
                            if (bd != null) {
                                b = bd[j >> 1];
                                id += 0xF & b;
                                id2 += (0xF0 & b) >> 4;
                            }
                            states[j] = DynmapPlugin.stateByID[id];
                            states[j + 1] = DynmapPlugin.stateByID[id2];
                        }
                    }
                    cursect.emitlight = sec.func_74770_j("BlockLight");
                    if (!sec.func_74764_b("SkyLight")) continue;
                    cursect.skylight = sec.func_74770_j("SkyLight");
                }
                this.biome = new int[256];
                if (!nbt.func_74764_b("Biomes")) break block18;
                byte[] b = nbt.func_74770_j("Biomes");
                if (b == null) break block19;
                for (int i = 0; i < b.length; ++i) {
                    int bv = 0xFF & b[i];
                    this.biome[i] = bv == 255 ? 0 : bv;
                }
                break block18;
            }
            int[] bb = nbt.func_74759_k("Biomes");
            if (bb == null) break block18;
            for (int i = 0; i < bb.length; ++i) {
                int bv = bb[i];
                this.biome[i] = bv < 0 ? 0 : bv;
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public DynmapBlockState getBlockType(int x, int y, int z) {
        return this.section[y >> 4].getBlockType(x, y, z);
    }

    public int getBlockSkyLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockSkyLight(x, y, z);
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockEmittedLight(x, y, z);
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.hmap[z << 4 | x];
    }

    public int getBiome(int x, int z) {
        return this.biome[z << 4 | x];
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public boolean isSectionEmpty(int sy) {
        return this.section[sy].isEmpty();
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    static {
        Arrays.fill(fullData, (byte)-1);
        empty_section = new EmptySection();
    }

    private static class StdSection
    implements Section {
        DynmapBlockState[] states = new DynmapBlockState[4096];
        byte[] skylight;
        byte[] emitlight;

        public StdSection() {
            Arrays.fill(this.states, DynmapBlockState.AIR);
            this.skylight = emptyData;
            this.emitlight = emptyData;
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return this.states[(y & 0xF) << 8 | z << 4 | x];
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.skylight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.emitlight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class EmptySection
    implements Section {
        private EmptySection() {
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static interface Section {
        public DynmapBlockState getBlockType(int var1, int var2, int var3);

        public int getBlockSkyLight(int var1, int var2, int var3);

        public int getBlockEmittedLight(int var1, int var2, int var3);

        public boolean isEmpty();
    }
}

