/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RotatedBoxRenderer
extends CustomRenderer {
    private RenderPatch[][] models;
    private Integer[] rotValues;
    private String idx_attrib = null;
    private String[] tileEntityAttribs = null;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        String v;
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.idx_attrib = custparm.get("textureIndex");
        ArrayList<Integer> map = new ArrayList<Integer>();
        int id = 0;
        while ((v = custparm.get("index" + id)) != null) {
            map.add(Integer.valueOf(v));
            ++id;
        }
        this.rotValues = map.toArray(new Integer[map.size()]);
        this.models = new RenderPatch[this.rotValues.length][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        RotatedBoxRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, null);
        for (int id2 = 0; id2 < this.rotValues.length; ++id2) {
            String v2 = custparm.get("map" + id2);
            if (v2 == null) {
                v2 = Integer.toString(90 * id2);
            }
            if (v2.startsWith("S")) {
                this.models[id2] = new RenderPatch[6];
                for (int i = 0; i < 6; ++i) {
                    int idx = 0;
                    try {
                        idx = v2.charAt(i + 1) - 48;
                        this.models[id2][i] = rpf.getRotatedPatch(list.get(i), 0, 0, 0, idx);
                        continue;
                    }
                    catch (Exception x) {
                        Log.severe("Invalid map format:" + v2);
                        return false;
                    }
                }
                continue;
            }
            String[] sv = v2.split("/");
            int x = 0;
            int y = 0;
            int z = 0;
            if (sv.length == 1) {
                try {
                    y = Integer.parseInt(v2);
                }
                catch (NumberFormatException nfx) {
                    Log.severe("Invalid map format:" + v2);
                    return false;
                }
            } else if (sv.length == 3) {
                try {
                    x = Integer.parseInt(sv[0]);
                    y = Integer.parseInt(sv[1]);
                    z = Integer.parseInt(sv[2]);
                }
                catch (NumberFormatException nfx) {
                    Log.severe("Invalid map format:" + v2);
                    return false;
                }
            } else {
                Log.severe("Invalid map format:" + v2);
                return false;
            }
            this.models[id2] = new RenderPatch[6];
            for (int i = 0; i < 6; ++i) {
                this.models[id2][i] = rpf.getRotatedPatch(list.get(i), x, y, z, i);
            }
        }
        if (this.idx_attrib != null) {
            this.tileEntityAttribs = new String[1];
            this.tileEntityAttribs[0] = this.idx_attrib;
        } else {
            this.tileEntityAttribs = null;
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 6;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return this.tileEntityAttribs;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int textureIdx = 0;
        if (this.idx_attrib != null) {
            Object idxv = ctx.getBlockTileEntityField(this.idx_attrib);
            if (idxv instanceof Number) {
                textureIdx = ((Number)idxv).intValue();
            }
        } else {
            textureIdx = ctx.getBlockType().stateIndex;
        }
        for (int i = 0; i < this.rotValues.length; ++i) {
            if (this.rotValues[i] != textureIdx) continue;
            return this.models[i];
        }
        Log.info("Unmatched rotation index: " + textureIdx + " for " + ctx.getBlockType());
        return this.models[0];
    }
}

