/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dynmap.Component;

public class ComponentManager {
    public Set<Component> components = new HashSet<Component>();
    public Map<String, List<Component>> componentLookup = new HashMap<String, List<Component>>();

    public void add(Component c) {
        if (this.components.add(c)) {
            String key = c.getClass().toString();
            List<Component> clist = this.componentLookup.get(key);
            if (clist == null) {
                clist = new ArrayList<Component>();
                this.componentLookup.put(key, clist);
            }
            clist.add(c);
        }
    }

    public void remove(Component c) {
        String key;
        List<Component> clist;
        if (this.components.remove(c) && (clist = this.componentLookup.get(key = c.getClass().toString())) != null) {
            clist.remove(c);
        }
    }

    public void clear() {
        this.componentLookup.clear();
        this.components.clear();
    }

    public Iterable<Component> getComponents(Class<Component> c) {
        List<Component> list = this.componentLookup.get(c.toString());
        if (list == null) {
            return new ArrayList<Component>();
        }
        return list;
    }
}

