/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.utils.MapChunkCache;

public abstract class MapTile {
    protected DynmapWorld world;

    public abstract boolean render(MapChunkCache var1, String var2);

    public abstract List<DynmapChunk> getRequiredChunks();

    public abstract MapTile[] getAdjecentTiles();

    public DynmapWorld getDynmapWorld() {
        return this.world;
    }

    public MapTile(DynmapWorld world) {
        this.world = world;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract boolean isBiomeDataNeeded();

    public abstract boolean isHightestBlockYDataNeeded();

    public abstract boolean isRawBiomeDataNeeded();

    public abstract boolean isBlockTypeDataNeeded();

    public abstract int tileOrdinalX();

    public abstract int tileOrdinalY();

    public ConfigurationNode saveTile() {
        ConfigurationNode cn = new ConfigurationNode();
        cn.put("class", (Object)this.getClass().getName());
        cn.put("data", (Object)this.saveTileData());
        return cn;
    }

    protected abstract String saveTileData();

    public static MapTile restoreTile(DynmapWorld w, ConfigurationNode node) {
        String cn = node.getString("class");
        String dat = node.getString("data");
        if (cn == null || dat == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(cn);
            Constructor<?> con = cls.getConstructor(DynmapWorld.class, String.class);
            return (MapTile)con.newInstance(w, dat);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }
}

