/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class MushroomStateRenderer
extends CustomRenderer {
    private static final int TEXTURE_OUTSIDE = 0;
    private static final int TEXTURE_INSIDE = 1;
    protected RenderPatch[][] meshes = new RenderPatch[64][];

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        this.buildPatches(rpf);
        return true;
    }

    private void buildPatches(RenderPatchFactory rpf) {
        int[] faces = new int[6];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int i = 0; i < 64; ++i) {
            list.clear();
            faces[0] = (i & 0x20) == 0 ? 0 : 1;
            faces[1] = (i & 2) == 0 ? 0 : 1;
            faces[2] = (i & 1) == 0 ? 0 : 1;
            faces[3] = (i & 0x10) == 0 ? 0 : 1;
            faces[4] = (i & 8) == 0 ? 0 : 1;
            faces[5] = (i & 4) == 0 ? 0 : 1;
            CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, faces);
            this.meshes[i] = list.toArray(new RenderPatch[list.size()]);
        }
    }

    @Override
    public int getMaximumTextureCount() {
        return 2;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        return this.meshes[ctx.getBlockType().stateIndex];
    }
}

