/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_16_2;

import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.forge_1_16_2.ForgeMapChunkCache;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class ForgeWorld
extends DynmapWorld {
    private IServerWorld world = null;
    private final boolean skylight;
    private final boolean isnether;
    private final boolean istheend;
    private final String env;
    private DynmapLocation spawnloc = new DynmapLocation();
    private static int maxWorldHeight = 256;

    public static int getMaxWorldHeight() {
        return maxWorldHeight;
    }

    public static void setMaxWorldHeight(int h) {
        maxWorldHeight = h;
    }

    public static String getWorldName(IServerWorld w) {
        RegistryKey rk = w.func_201672_e().func_234923_W_();
        if (rk == World.field_234918_g_) {
            return w.func_201672_e().func_73046_m().func_240793_aU_().func_76065_j();
        }
        if (rk == World.field_234920_i_) {
            return "DIM1";
        }
        if (rk == World.field_234919_h_) {
            return "DIM-1";
        }
        return rk.func_240901_a_().func_110624_b() + "_" + rk.func_240901_a_().func_110623_a();
    }

    public ForgeWorld(IServerWorld w) {
        this(ForgeWorld.getWorldName(w), w.func_201672_e().func_217301_I(), w.func_201672_e().func_181545_F(), w.func_201672_e().func_234923_W_() == World.field_234920_i_, w.func_201672_e().func_234923_W_() == World.field_234919_h_, w.func_201672_e().func_234923_W_().func_240901_a_().func_110623_a());
        this.setWorldLoaded(w);
    }

    public ForgeWorld(String name, int height, int sealevel, boolean nether, boolean the_end, String deftitle) {
        super(name, height > maxWorldHeight ? maxWorldHeight : height, sealevel);
        this.setTitle(deftitle);
        this.isnether = nether;
        this.istheend = the_end;
        boolean bl = this.skylight = !this.isnether && !this.istheend;
        this.env = this.isnether ? "nether" : (this.istheend ? "the_end" : "normal");
    }

    @Override
    public boolean isNether() {
        return this.isnether;
    }

    public boolean isTheEnd() {
        return this.istheend;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            this.spawnloc.x = this.world.func_72912_H().func_76079_c();
            this.spawnloc.y = this.world.func_72912_H().func_76075_d();
            this.spawnloc.z = this.world.func_72912_H().func_76074_e();
            this.spawnloc.world = this.getName();
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.func_201672_e().func_82737_E();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.func_201672_e().func_72896_J();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.func_201672_e().func_72911_I();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    public void setWorldLoaded(IServerWorld w) {
        this.world = w;
        this.sealevel = w.func_181545_F();
        for (int i = 0; i < 16; ++i) {
            this.setBrightnessTableEntry(i, w.func_201672_e().func_230315_m_().func_236021_a_(i));
        }
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_201696_r(new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.func_201672_e().func_212866_a_(x >> 4, z >> 4).func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(x & 0xF, z & 0xF);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_226658_a_(LightType.SKY, new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.world != null) {
            ForgeMapChunkCache c = new ForgeMapChunkCache();
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public World getWorld() {
        return this.world.func_201672_e();
    }

    @Override
    public Polygon getWorldBorder() {
        WorldBorder wb;
        if (this.world != null && (wb = this.world.func_175723_af()) != null && wb.func_177741_h() < 5.9E7) {
            Polygon p = new Polygon();
            p.addVertex(wb.func_177726_b(), wb.func_177736_c());
            p.addVertex(wb.func_177726_b(), wb.func_177733_e());
            p.addVertex(wb.func_177728_d(), wb.func_177733_e());
            p.addVertex(wb.func_177728_d(), wb.func_177736_c());
            return p;
        }
        return null;
    }
}

