/*
 * Decompiled with CFR 0.152.
 */
package thut.api.maths;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import thut.api.entity.IMultibox;
import thut.api.maths.Vector3;

public class Matrix3 {
    public Vector3[] rows = new Vector3[3];
    private List<Vector3> corners = new ArrayList<Vector3>();
    private static AxisAlignedBB[] pool = new AxisAlignedBB[10000];
    private static int index = 0;
    private Vector3 temp1;
    private Vector3 temp;
    private Vector3 ent;
    private Vector3 dir;
    private Vector3 temp2;
    private Vector3 mid = Vector3.getNewVectorFromPool();
    private Matrix3 box;
    int size = 3;
    List<Vector3> cornersList = new ArrayList<Vector3>();
    Vector3[] pointSet;

    public static synchronized AxisAlignedBB getAABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (index > 0) {
            AxisAlignedBB ret = pool[index - 1];
            --index;
            if (ret != null) {
                return ret.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
            }
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static synchronized void freeAABB(AxisAlignedBB box) {
        if (index < pool.length - 1 && index >= 0) {
            Matrix3.pool[Matrix3.index] = box;
            ++index;
        }
    }

    public Matrix3() {
        this.rows[0] = Vector3.getNewVectorFromPool();
        this.rows[1] = Vector3.getNewVectorFromPool();
        this.rows[2] = Vector3.getNewVectorFromPool();
    }

    public Matrix3(double[] a, double[] b, double[] c) {
        this();
        this.rows[0].set(a[0], a[1], a[2]);
        this.rows[1].set(b[0], b[1], b[2]);
        this.rows[2].set(c[0], c[1], c[2]);
    }

    public Matrix3(Vector3 a, Vector3 b, Vector3 c) {
        this.rows[0] = a.copy();
        this.rows[1] = b.copy();
        this.rows[2] = c.copy();
    }

    public Matrix3(Vector3 a, Vector3 b) {
        this(a, b, Vector3.empty);
    }

    public Matrix3(double d, double e, double f) {
        this();
        this.rows[1].set(d, e, f);
    }

    public Vector3 get(int i) {
        assert (i < 3);
        return this.rows[i];
    }

    public Vector3 boxMin() {
        return this.rows[0];
    }

    public Vector3 boxMax() {
        return this.rows[1];
    }

    public Vector3 boxRotation() {
        return this.rows[2];
    }

    public Vector3 boxCentre() {
        if (this.temp == null) {
            this.temp = Vector3.getNewVectorFromPool();
        }
        if (this.temp1 == null) {
            this.temp1 = Vector3.getNewVectorFromPool();
        }
        if (this.temp2 == null) {
            this.temp2 = Vector3.getNewVectorFromPool();
        }
        this.temp.set(this.temp1);
        this.temp1.set(this.boxMax());
        this.temp2.set(this.temp1);
        this.mid.set(this.temp2.subtractFrom(this.temp1.subtractFrom(this.boxMin()).scalarMultBy(0.5)));
        this.temp1.set(this.temp);
        return this.mid;
    }

    public double get(int i, int j) {
        assert (i < 3);
        return this.rows[i].get(j);
    }

    public Vector3[] corners(Vector3 mid) {
        this.corners(mid != null);
        return this.corners.toArray(new Vector3[8]);
    }

    private void corners(boolean rotate) {
        int i;
        if (this.corners.isEmpty()) {
            for (i = 0; i < 8; ++i) {
                this.corners.add(Vector3.getNewVectorFromPool());
            }
        }
        if (this.temp == null) {
            this.temp = Vector3.getNewVectorFromPool();
        }
        if (this.temp2 == null) {
            this.temp2 = Vector3.getNewVectorFromPool();
        }
        this.corners.get(0).set(this.boxMin());
        this.corners.get(1).set(this.boxMax());
        this.corners.get(2).set(this.boxMin().x, this.boxMin().y, this.boxMax().z);
        this.corners.get(3).set(this.boxMin().x, this.boxMax().y, this.boxMin().z);
        this.corners.get(4).set(this.boxMax().x, this.boxMin().y, this.boxMin().z);
        this.corners.get(5).set(this.boxMin().x, this.boxMax().y, this.boxMax().z);
        this.corners.get(6).set(this.boxMax().x, this.boxMin().y, this.boxMax().z);
        this.corners.get(7).set(this.boxMax().x, this.boxMax().y, this.boxMin().z);
        this.mid = rotate ? this.boxCentre() : null;
        if (!this.boxRotation().isEmpty() && this.mid != null) {
            for (i = 0; i < 8; ++i) {
                this.corners.get(i).subtractFrom(this.mid);
            }
            Vector3.rotateAboutAngles(this.corners.toArray(new Vector3[8]), this.boxRotation().y, this.boxRotation().z, this.temp2, this.temp);
            for (i = 0; i < 8; ++i) {
                this.corners.get(i).addTo(this.mid);
            }
        }
    }

    public Matrix3 addOffsetTo(Vector3 pushOffset) {
        this.rows[0].addTo(pushOffset);
        this.rows[1].addTo(pushOffset);
        return this;
    }

    public Matrix3 copy() {
        Matrix3 ret = new Matrix3();
        ret.rows[0].set(this.rows[0]);
        ret.rows[1].set(this.rows[1]);
        ret.rows[2].set(this.rows[2]);
        return ret;
    }

    public Matrix3 set(int i, Vector3 j) {
        assert (i < 3);
        this.rows[i] = j;
        return this;
    }

    public void set(int i, int j, double k) {
        this.rows[i].set(j, k);
    }

    public double[][] toArray() {
        return new double[][]{{this.rows[0].x, this.rows[0].y, this.rows[0].z}, {this.rows[1].x, this.rows[1].y, this.rows[1].z}, {this.rows[2].x, this.rows[2].y, this.rows[2].z}};
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        return eol + "0: " + this.rows[0].toString() + eol + "1: " + this.rows[1].toString() + eol + "2 : " + this.rows[2].toString();
    }

    public static Matrix3 matrixTranspose(Matrix3 Matrix) {
        Matrix3 MatrixT = new Matrix3();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                MatrixT.set(i, j, Matrix.get(j, i));
            }
        }
        return MatrixT;
    }

    public static double matrixDet(Matrix3 Matrix) {
        double det = 0.0;
        int n = Matrix.size;
        if (n == 2) {
            det = Matrix.get(0, 0) * Matrix.get(1, 1) - Matrix.get(1, 0) * Matrix.get(0, 1);
        } else {
            for (int i = 0; i < n; ++i) {
                det += Math.pow(-1.0, i) * Matrix.get(0, i) * Matrix3.matrixDet(Matrix3.matrixMinor(Matrix, 0, i));
            }
        }
        return det;
    }

    public static Matrix3 matrixMinor(Matrix3 input, int i, int j) {
        int k;
        double[][] Matrix = input.toArray();
        int n = Matrix.length;
        int m = Matrix[0].length;
        Double[][] TempMinor = new Double[m - 1][n - 1];
        ArrayList row = new ArrayList();
        for (k = 0; k < n; ++k) {
            if (k == i) continue;
            row.add(new ArrayList());
            for (int l = 0; l < m; ++l) {
                if (l == j) continue;
                ((ArrayList)row.get(k - (k > i ? 1 : 0))).add(Matrix[k][l]);
            }
        }
        for (k = 0; k < n - 1; ++k) {
            TempMinor[k] = ((ArrayList)row.get(k)).toArray(new Double[0]);
        }
        Matrix3 Minor = new Matrix3();
        Minor.size = n - 1;
        for (int k2 = 0; k2 < n - 1; ++k2) {
            for (int l = 0; l < m - 1; ++l) {
                Minor.set(k2, l, TempMinor[k2][l]);
            }
        }
        return Minor;
    }

    public Matrix3 getOctant(int octant) {
        Matrix3 ret = this.copy();
        switch (octant) {
            case 0: {
                ret.rows[0].x = this.rows[0].x + this.rows[1].x / 2.0;
                ret.rows[0].y = this.rows[0].y + this.rows[1].y / 2.0;
                ret.rows[0].z = this.rows[0].z + this.rows[1].z / 2.0;
                return ret;
            }
            case 1: {
                ret.rows[1].x = this.rows[1].x - this.rows[1].x / 2.0;
                ret.rows[0].y = this.rows[0].y + this.rows[1].y / 2.0;
                ret.rows[0].z = this.rows[0].z + this.rows[1].z / 2.0;
                return ret;
            }
            case 2: {
                ret.rows[1].x = this.rows[1].x - this.rows[1].x / 2.0;
                ret.rows[1].y = this.rows[1].y - this.rows[1].y / 2.0;
                ret.rows[0].z = this.rows[0].z + this.rows[1].z / 2.0;
                return ret;
            }
            case 3: {
                ret.rows[0].x = this.rows[0].x + this.rows[1].x / 2.0;
                ret.rows[1].y = this.rows[1].y - this.rows[1].y / 2.0;
                ret.rows[0].z = this.rows[0].z + this.rows[1].z / 2.0;
                return ret;
            }
            case 4: {
                ret.rows[0].x = this.rows[0].x + this.rows[1].x / 2.0;
                ret.rows[0].y = this.rows[0].y + this.rows[1].y / 2.0;
                ret.rows[1].z = this.rows[1].z - this.rows[1].z / 2.0;
                return ret;
            }
            case 5: {
                ret.rows[1].x = this.rows[1].x - this.rows[1].x / 2.0;
                ret.rows[0].y = this.rows[0].y + this.rows[1].y / 2.0;
                ret.rows[1].z = this.rows[1].z - this.rows[1].z / 2.0;
                return ret;
            }
            case 6: {
                ret.rows[1].x = this.rows[1].x - this.rows[1].x / 2.0;
                ret.rows[1].y = this.rows[1].y - this.rows[1].y / 2.0;
                ret.rows[1].z = this.rows[1].z - this.rows[1].z / 2.0;
                return ret;
            }
            case 7: {
                ret.rows[0].x = this.rows[0].x + this.rows[1].x / 2.0;
                ret.rows[1].y = this.rows[1].y - this.rows[1].y / 2.0;
                ret.rows[1].z = this.rows[1].z - this.rows[1].z / 2.0;
                return ret;
            }
        }
        return ret;
    }

    public Matrix3 resizeBox(double x, double y, double z) {
        Matrix3 ret = this.copy();
        ret.boxMin().x -= x;
        ret.boxMin().y -= y;
        ret.boxMin().z -= z;
        ret.boxMax().x += x;
        ret.boxMax().y += y;
        ret.boxMax().z += z;
        return ret;
    }

    public Vector3 doTileCollision(IBlockAccess world, Entity e, Vector3 offset, Vector3 diffs) {
        if (this.temp == null) {
            this.temp = Vector3.getNewVectorFromPool();
        }
        if (this.dir == null) {
            this.dir = Vector3.getNewVectorFromPool();
        }
        if (this.temp1 == null) {
            this.temp1 = Vector3.getNewVectorFromPool();
        }
        if (this.ent == null) {
            this.ent = Vector3.getNewVectorFromPool();
        }
        this.cornersList.clear();
        this.ent.set(e);
        this.temp.set(this.ent).addTo(diffs).addTo(offset);
        this.temp1.set(diffs);
        if (this.box == null) {
            this.box = this.copy();
        } else {
            this.box.clear();
            this.box.set(this);
        }
        Matrix3 mob = this.box.addOffsetTo(this.temp);
        int n = 0;
        e.field_70122_E = false;
        for (Vector3 v : mob.corners(mob.boxCentre())) {
            this.cornersList.add(v);
        }
        double minX = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Vector3 v : this.cornersList) {
            if (v.x > maxX) {
                maxX = v.x;
            }
            if (v.y > maxY) {
                maxY = v.y;
            }
            if (v.z > maxZ) {
                maxZ = v.z;
            }
            if (v.x < minX) {
                minX = v.x;
            }
            if (v.y < minY) {
                minY = v.y;
            }
            if (!(v.z < minZ)) continue;
            minZ = v.z;
        }
        double dx = Math.max(maxX - minX, 1.0);
        double dy = Math.max(maxY - minY, 1.0);
        double dz = Math.max(maxZ - minZ, 1.0);
        AxisAlignedBB aabb = mob.boxCentre().getAABB().func_72314_b(dx, dy, dz);
        List list = e.field_70170_p.func_147461_a(aabb);
        Matrix3.freeAABB(aabb);
        List aabbs = list;
        double[] corners = new double[]{minY, maxY, minZ, maxZ, minX, maxX};
        double[] pens = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        boolean justDown = true;
        double minCeiling = 2.147483647E9;
        double maxFloor = -1.0;
        boolean[] dirs = new boolean[6];
        for (AxisAlignedBB box : aabbs) {
            if (!this.doAABBcollision(box, corners, pens, dirs, diffs)) continue;
            if (dirs[0]) {
                boolean downForBlock = diffs.y < 0.0 && minY >= box.field_72338_b;
                justDown = justDown && downForBlock;
                e.field_70122_E = true;
                if (downForBlock || box.field_72337_e - e.field_70163_u <= (double)e.field_70138_W) {
                    maxFloor = Math.max(maxFloor, box.field_72337_e);
                }
            }
            if (dirs[1]) {
                minCeiling = Math.min(minCeiling, box.field_72338_b);
            }
            ++n;
        }
        for (int i = 0; i < 6; ++i) {
            if (pens[i] != Double.MAX_VALUE) continue;
            pens[i] = 0.0;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            justDown = dirs[0] && !dirs[1] && !dirs[2] && !dirs[3] && !dirs[4] && !dirs[5];
        }
        this.dir.clear();
        boolean test = false;
        if (!justDown) {
            for (int i = 1; i < 6; ++i) {
                this.dir.set(EnumFacing.func_82600_a((int)i)).scalarMultBy(-0.01).scalarMultBy(pens[i]);
                if (Math.abs(this.dir.x) > 0.0) {
                    this.temp1.x = this.dir.x;
                }
                if (Math.abs(this.dir.z) > 0.0) {
                    this.temp1.z = this.dir.z;
                }
                if (!(Math.abs(this.dir.y) > 0.0)) continue;
                this.temp1.y = this.dir.y;
            }
        }
        if (dirs[2] || dirs[3] || dirs[4] || dirs[5]) {
            // empty if block
        }
        if (dirs[1]) {
            this.temp1.y = -pens[1];
        }
        if (!(!dirs[0] || dirs[1] && pens[0] > 0.5)) {
            test = true;
            this.temp1.y = maxFloor - e.field_70163_u;
        }
        return this.temp1;
    }

    public void set(Matrix3 box) {
        this.rows[0].set(box.rows[0]);
        this.rows[1].set(box.rows[1]);
        this.rows[2].set(box.rows[2]);
    }

    public boolean doTileCollision(IBlockAccess world, Vector3 location, Entity e, Vector3 offset, Vector3 diffs) {
        if (!(e instanceof IMultibox)) {
            return false;
        }
        return !this.doTileCollision(world, e, offset, diffs).equals(diffs);
    }

    public boolean isInMaterial(IBlockAccess world, Vector3 location, Entity e, Vector3 offset, Material m) {
        if (!(e instanceof IMultibox)) {
            return false;
        }
        boolean ret = false;
        Vector3 ent = location;
        if (this.temp == null) {
            this.temp = Vector3.getNewVectorFromPool();
        } else {
            this.temp.clear();
        }
        if (this.dir == null) {
            this.dir = Vector3.getNewVectorFromPool();
        } else {
            this.dir.clear();
        }
        if (this.temp1 == null) {
            this.temp1 = Vector3.getNewVectorFromPool();
        } else {
            this.temp1.clear();
        }
        Vector3[] corners = this.corners(this.boxCentre());
        for (int i = 0; i < 8; ++i) {
            Vector3 v = corners[i];
            this.dir.set(v);
            this.temp.set(this.dir.addTo(ent).addTo(offset));
            if (this.temp.getBlockMaterial(world) == m) {
                return true;
            }
            if (i % 2 != 0) continue;
            this.temp.addTo(0.0, 0.01, 0.0);
            if (this.temp.getBlockMaterial(world) != m) continue;
            return true;
        }
        return false;
    }

    public boolean doAABBcollision(AxisAlignedBB box, double[] corners, double[] pens, boolean[] dirs, Vector3 diffs) {
        boolean in;
        double minX = corners[4];
        double minZ = corners[2];
        double minY = corners[0];
        double maxX = corners[5];
        double maxZ = corners[3];
        double maxY = corners[1];
        boolean collidesX = maxZ <= box.field_72334_f && maxZ >= box.field_72339_c || minZ <= box.field_72334_f && minZ >= box.field_72339_c;
        boolean collidesY = minY >= box.field_72338_b && minY <= box.field_72337_e || maxY <= box.field_72337_e && maxY >= box.field_72338_b;
        boolean collidesZ = maxX <= box.field_72336_d && maxX >= box.field_72340_a || minX <= box.field_72336_d && minX >= box.field_72340_a;
        collidesZ = collidesZ && (collidesX || collidesY);
        collidesX = collidesX && (collidesZ || collidesY);
        boolean bl = in = collidesZ && collidesX;
        if (!in) {
            return false;
        }
        if (collidesY) {
            if (minY >= box.field_72338_b && minY <= box.field_72337_e) {
                pens[0] = Math.min(pens[0], Math.abs(box.field_72337_e - minY));
                dirs[0] = true;
            } else if (maxY <= box.field_72337_e && maxY >= box.field_72338_b) {
                pens[1] = Math.min(pens[1], Math.abs(box.field_72338_b - maxY));
                dirs[1] = true;
            }
        }
        if (collidesZ) {
            if (diffs.z < 0.0) {
                pens[2] = Math.min(pens[2], Math.abs(box.field_72339_c - minZ));
                dirs[2] = true;
            } else if (diffs.z > 0.0) {
                pens[3] = Math.min(pens[3], Math.abs(box.field_72334_f - maxZ));
                dirs[3] = true;
            }
        }
        if (collidesX) {
            if (diffs.x < 0.0) {
                pens[4] = Math.min(pens[4], Math.abs(box.field_72336_d - maxX));
                dirs[4] = true;
            } else if (diffs.x > 0.0) {
                pens[5] = Math.min(pens[5], Math.abs(box.field_72336_d - maxX));
                dirs[5] = true;
            }
        }
        return true;
    }

    public boolean doCollision(Vector3 boxVelocity, Entity e) {
        boolean ret = false;
        if (e == null) {
            return false;
        }
        if (this.dir == null) {
            this.dir = Vector3.getNewVectorFromPool();
        }
        if (this.ent == null) {
            this.ent = Vector3.getNewVectorFromPool();
        }
        if (this.temp2 == null) {
            this.temp2 = Vector3.getNewVectorFromPool();
        }
        this.ent.set(e);
        this.corners(true);
        if (e instanceof IMultibox) {
            IMultibox e1 = (IMultibox)e;
            e1.setOffsets();
            e1.setBoxes();
            ConcurrentHashMap<String, Matrix3> boxes = e1.getBoxes();
            ConcurrentHashMap<String, Vector3> offsets = e1.getOffsets();
            for (String s : boxes.keySet()) {
                Vector3 boxOff = offsets.containsKey(s) ? (Vector3)offsets.get(s) : Vector3.empty;
                Matrix3 box = (Matrix3)boxes.get(s);
                box.addOffsetTo(boxOff).addOffsetTo(this.ent);
                boolean hit = box.intersects(this);
                box.addOffsetTo(boxOff.reverse()).addOffsetTo(this.ent.reverse());
                boxOff.reverse();
                this.ent.reverse();
                Vector3.empty.clear();
                if (!hit) continue;
                return true;
            }
        } else {
            if (this.box == null) {
                this.box = new Matrix3();
            }
            this.box.set(e.field_70121_D);
            boolean hit = this.box.intersects(this);
            if (hit) {
                return true;
            }
        }
        return ret;
    }

    public void set(AxisAlignedBB aabb) {
        this.rows[0].x = aabb.field_72340_a;
        this.rows[0].y = aabb.field_72338_b;
        this.rows[0].z = aabb.field_72339_c;
        this.rows[1].x = aabb.field_72336_d;
        this.rows[1].y = aabb.field_72337_e;
        this.rows[1].z = aabb.field_72334_f;
        this.rows[2].clear();
    }

    public boolean intersects(Matrix3 b) {
        ArrayList<Vector3> cornersB = new ArrayList<Vector3>();
        for (Vector3 v : b.corners(this.boxCentre())) {
            cornersB.add(v);
        }
        return this.intersects(cornersB);
    }

    public boolean intersects(List<Vector3> mesh) {
        ArrayList<Vector3> cornersA = new ArrayList<Vector3>();
        for (Vector3 v : this.corners(this.boxCentre())) {
            cornersA.add(v);
        }
        List<Vector3> diffs = this.diff(cornersA, mesh);
        boolean temp = Matrix3.containsOrigin(diffs);
        for (Vector3 v : diffs) {
            v.freeVectorFromPool();
        }
        return temp;
    }

    static List<Vector3> toMesh(ArrayList<Matrix3> boxes) {
        ArrayList<Vector3> ret = new ArrayList<Vector3>();
        for (Matrix3 box : boxes) {
            for (Vector3 v : box.corners(box.boxCentre())) {
                boolean has = false;
                for (Vector3 v1 : ret) {
                    if (!v1.equals(v)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                ret.add(v);
            }
        }
        return ret;
    }

    private List<Vector3> diff(List<Vector3> cornersA, List<Vector3> cornersB) {
        ArrayList<Vector3> ret = new ArrayList<Vector3>();
        Vector3 c = Vector3.getNewVectorFromPool();
        if (this.pointSet == null) {
            this.pointSet = new Vector3[100];
        }
        int n = 0;
        for (Vector3 a : cornersA) {
            for (Vector3 b : cornersB) {
                c.set(a).subtractFrom(b);
                this.pointSet[n++] = c.copy();
            }
        }
        c.freeVectorFromPool();
        for (int i = 0; i < n; ++i) {
            Vector3 v = this.pointSet[i];
            ret.add(v);
            this.pointSet[i] = null;
        }
        return ret;
    }

    private static boolean containsOrigin(List<Vector3> points) {
        int index = 0;
        int n = 0;
        Vector3 base = points.get(index);
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            double d = points.get(i).magSq();
            if (!(d < dist)) continue;
            base = points.get(i);
            dist = d;
            index = i;
        }
        Vector3 mid = Vector3.findMidPoint(points);
        points.remove(index);
        boolean ret = false;
        for (int i = 0; i < points.size(); ++i) {
            Vector3 v = points.get(i);
            double d = v.dot(base);
            double d1 = v.dot(mid);
            if (!(d <= 0.0) || !(d1 <= d) || Math.signum(d) != Math.signum(d1)) continue;
            ret = true;
            ++n;
            return true;
        }
        return ret;
    }

    public Matrix3 clear() {
        this.rows[0].clear();
        this.rows[1].clear();
        this.rows[2].clear();
        return this;
    }
}

