/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.client.render;

import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thut.api.ThutBlocks;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;

public class RenderLiftController
extends TileEntitySpecialRenderer {
    public static final int ID = RenderingRegistry.getNextAvailableRenderId();
    private ModelLiftController _model = new ModelLiftController();
    private RenderBlocks blocks = new RenderBlocks();
    private static final double _renderMin = 0.0625;
    private static final double _renderMax = 0.9375;
    private ResourceLocation texture;

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityLiftAccess monitor = (TileEntityLiftAccess)tileentity;
        if (monitor.func_145838_q() == ThutBlocks.liftRail) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            if (!monitor.isSideOn(i)) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            if (dir == ForgeDirection.EAST) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == ForgeDirection.SOUTH) {
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (dir == ForgeDirection.WEST) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/controlPanel_1.png");
                renderengine.func_110577_a(this.texture);
            }
            GL11.glPushAttrib((int)3042);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushAttrib((int)64);
            RenderHelper.func_74518_a();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            Tessellator t = Tessellator.field_78398_a;
            t.func_78371_b(7);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-5.0E-4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            t.func_78374_a(1.0, 1.0, 0.0, 0.0, 0.0);
            t.func_78374_a(1.0, 0.0, 0.0, 0.0, 1.0);
            t.func_78374_a(0.0, 0.0, 0.0, 1.0, 1.0);
            t.func_78374_a(0.0, 1.0, 0.0, 1.0, 0.0);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopAttrib();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            this.drawFloorNumbers(monitor.getSidePage(i));
            this.drawOverLay(monitor, monitor.floor, 0, i);
            this.drawOverLay(monitor, monitor.calledFloor, 1, i);
            this.drawOverLay(monitor, monitor.currentFloor, 2, i);
            if (monitor.lift != null) {
                for (int j = monitor.getSidePage(i) * 16; j < 16 + monitor.getSidePage(i) * 16; ++j) {
                    if (monitor.lift.floors[j] >= 0) continue;
                    this.drawOverLay(monitor, j + 1, 3, i);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void drawFloorNumbers(int page) {
        for (int floor = 0; floor < 16; ++floor) {
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/font.png");
                renderengine.func_110577_a(this.texture);
            }
            GL11.glPushAttrib((int)3042);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushAttrib((int)64);
            Tessellator t = Tessellator.field_78398_a;
            t.func_78371_b(7);
            double x = (double)(3 - floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            int actFloor = floor + page * 16;
            double[] uvs = this.locationFromNumber((actFloor + 1) % 10);
            double[] uvs1 = this.locationFromNumber((actFloor + 1) / 10);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (actFloor > 8) {
                GL11.glTranslated((double)(x + 0.01), (double)(y + 0.06), (double)-0.006);
                t.func_78374_a(0.15, 0.15, 0.0, uvs[0], uvs[2]);
                t.func_78374_a(0.15, 0.0, 0.0, uvs[0], uvs[3]);
                t.func_78374_a(0.0, 0.0, 0.0, uvs[1], uvs[3]);
                t.func_78374_a(0.0, 0.15, 0.0, uvs[1], uvs[2]);
                t.func_78374_a(0.25, 0.15, 0.0, uvs1[0], uvs1[2]);
                t.func_78374_a(0.25, 0.0, 0.0, uvs1[0], uvs1[3]);
                t.func_78374_a(0.1, 0.0, 0.0, uvs1[1], uvs1[3]);
                t.func_78374_a(0.1, 0.15, 0.0, uvs1[1], uvs1[2]);
            } else {
                GL11.glTranslated((double)(x + 0.05), (double)(y + 0.06), (double)-0.006);
                t.func_78374_a(0.15, 0.15, 0.0, uvs[0], uvs[2]);
                t.func_78374_a(0.15, 0.0, 0.0, uvs[0], uvs[3]);
                t.func_78374_a(0.0, 0.0, 0.0, uvs[1], uvs[3]);
                t.func_78374_a(0.0, 0.15, 0.0, uvs[1], uvs[2]);
            }
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopAttrib();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public void drawOverLay(TileEntityLiftAccess monitor, int floor, int colour, int side) {
        if (monitor.func_145832_p() == 1 && monitor.func_145838_q() == ThutBlocks.lift && (floor -= monitor.getSidePage(side) * 16) > 0 && floor < 17) {
            TextureManager renderengine = Minecraft.func_71410_x().field_71446_o;
            String col = colour == 0 ? "green" : (colour == 1 ? "orange" : (colour == 2 ? "blue" : "gray"));
            GL11.glPushMatrix();
            if (renderengine != null) {
                this.texture = new ResourceLocation("thuttech:textures/blocks/" + col + "Overlay.png");
                renderengine.func_110577_a(this.texture);
            }
            GL11.glPushAttrib((int)3042);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushAttrib((int)64);
            RenderHelper.func_74518_a();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            double x = (double)(3 - --floor & 3) / 4.0;
            double y = (3.0 - (double)(floor >> 2)) / 4.0;
            GL11.glTranslated((double)x, (double)y, (double)(-0.001 * (double)(colour + 1)));
            Tessellator t = Tessellator.field_78398_a;
            t.func_78371_b(7);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            t.func_78374_a(0.25, 0.25, 0.0, 0.0, 0.0);
            t.func_78374_a(0.25, 0.0, 0.0, 0.0, 1.0);
            t.func_78374_a(0.0, 0.0, 0.0, 1.0, 1.0);
            t.func_78374_a(0.0, 0.25, 0.0, 1.0, 0.0);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopAttrib();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public double[] locationFromNumber(int number) {
        double[] ret = new double[4];
        if (number > 9 || number < 0) {
            return ret;
        }
        int index = 16 + number;
        ret[0] = (double)(index % 10) / 10.0;
        ret[2] = (double)(index / 10) / 10.0;
        ret[1] = (double)(1 + index % 10) / 10.0;
        ret[3] = (double)(1 + index / 10) / 10.0;
        return ret;
    }

    public static class ModelLiftController
    extends ModelBase {
        private ModelRenderer _main;

        public ModelLiftController() {
            this.field_78090_t = 64;
            this.field_78089_u = 32;
            this._main = new ModelRenderer((ModelBase)this, 0, 0);
            this._main.func_78789_a(0.0f, 0.0f, 0.0f, 1, 1, 1);
            this._main.func_78793_a(0.0f, 0.0f, 0.0f);
            this._main.func_78787_b(64, 32);
            this._main.field_78809_i = true;
            this.setRotation(this._main, 0.0f, 0.0f, 0.0f);
        }

        public void render(TileEntity te) {
            this._main.func_78785_a(1.0f);
        }

        private void setRotation(ModelRenderer model, float x, float y, float z) {
            model.field_78795_f = x;
            model.field_78796_g = y;
            model.field_78808_h = z;
        }
    }
}

