/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.common.util.RotationHelper;
import thut.api.ThutBlocks;
import thut.api.blocks.multiparts.parts.PartRebar;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.items.ItemLinker;

public class BlockLift
extends Block
implements ITileEntityProvider {
    public int size = 5;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon2;

    public BlockLift() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149675_a(true);
        this.func_149647_a(TechCore.tabThut);
        ThutBlocks.lift = this;
    }

    public int func_149660_a(World worldObj, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return meta;
    }

    public ForgeDirection getFacingfromEntity(EntityLiving e) {
        ForgeDirection side = null;
        double angle = e.field_70177_z % 360.0f;
        if (angle > 315.0 || angle <= 45.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return ForgeDirection.WEST;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return ForgeDirection.NORTH;
        }
        if (angle > 225.0 && angle <= 315.0) {
            return ForgeDirection.EAST;
        }
        return side;
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = worldObj.func_72805_g(x, y, z);
        if (worldObj.field_72995_K) {
            return true;
        }
        if (meta == 1) {
            TileEntityLiftAccess te = (TileEntityLiftAccess)worldObj.func_147438_o(x, y, z);
            if (te != null && (!te.isSideOn(side) || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y)) {
                if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b() instanceof ItemLinker || player.func_70694_bm().func_77973_b() == Items.field_151055_y)) {
                    te.setSide(side, !te.isSideOn(side));
                    if (te != null) {
                        te.updateBlock();
                    }
                    return true;
                }
            } else if (te != null && te.isSideOn(side) && player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_70694_bm().func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_70694_bm().func_77973_b() instanceof ItemLinker)) {
                te.setSidePage(side, (te.getSidePage(side) + 1) % 4);
                if (te != null) {
                    te.updateBlock();
                }
                return true;
            }
            if (te != null) {
                te.updateBlock();
            }
        }
        boolean ret = false;
        boolean rails = false;
        if (meta == 0) {
            ret = this.checkRailsForSpawn(worldObj, true, x, y, z);
            if (!ret && (ret = this.checkRailsForSpawn(worldObj, false, x, y, z))) {
                rails = true;
            }
            if (!ret && worldObj.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("complete rails not found"));
            }
            ItemStack[][] blocks = null;
            if (ret) {
                blocks = this.checkBlocks(worldObj, x, y, z);
            }
            boolean bl = ret = blocks != null;
            if (ret && !worldObj.field_72995_K) {
                this.removeBlocks(worldObj, x, y, z);
                EntityLift lift = new EntityLift(worldObj, (double)x + 0.5, y, (double)z + 0.5, this.size);
                lift.blocks = blocks;
                worldObj.func_72838_d((Entity)lift);
            }
            if (!ret && rails && worldObj.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("complete base not found"));
            }
        } else if (meta == 1 && !worldObj.field_72995_K) {
            TileEntityLiftAccess te = (TileEntityLiftAccess)worldObj.func_147438_o(x, y, z);
            if (te != null) {
                te.doButtonClick(side, hitX, hitY, hitZ);
            }
            ret = true;
        }
        return ret;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityLiftAccess) {
            ((TileEntityLiftAccess)te).notifySurroundings();
        }
    }

    public boolean checkRailsForSpawn(World worldObj, boolean axis, int x, int y, int z) {
        int[] sizes = new int[]{5, 3, 1};
        boolean ret = false;
        BlockCoord pos = new BlockCoord();
        for (int j = 0; j < 3; ++j) {
            boolean bool = true;
            boolean rightBlock = false;
            int rail = (int)(1.0 + Math.floor(sizes[j] / 2));
            int colmn = sizes[j] / 2;
            int[][] sides = new int[][]{{rail, 0}, {-rail, 0}, {0, rail}, {0, -rail}};
            for (int i = 0; i < 3; ++i) {
                pos.set(x + sides[axis ? 2 : 0][0], y + i, z + sides[axis ? 2 : 0][1]);
                rightBlock = PartRebar.isRebar(worldObj, pos);
                bool = bool && rightBlock;
                pos.set(x + sides[axis ? 3 : 1][0], y + i, z + sides[axis ? 3 : 1][1]);
                rightBlock = PartRebar.isRebar(worldObj, pos);
                bool = bool && rightBlock;
            }
            if (!bool) continue;
            this.size = sizes[j];
            ret = bool;
            break;
        }
        return ret;
    }

    public ItemStack[][] checkBlocks(World worldObj, int x, int y, int z) {
        ItemStack[][] ret = new ItemStack[this.size][this.size];
        int rad = this.size / 2;
        for (int i = -rad; i <= rad; ++i) {
            for (int j = -rad; j <= rad; ++j) {
                if (i != 0 || j != 0) {
                    Block b = worldObj.func_147439_a(x + i, y, z + j);
                    if (b.func_149721_r()) {
                        ret[i + rad][j + rad] = new ItemStack(b, 1, worldObj.func_72805_g(x + i, y, z + j));
                        continue;
                    }
                    return null;
                }
                ret[i + rad][j + rad] = new ItemStack((Block)this);
            }
        }
        return ret;
    }

    public void removeBlocks(World worldObj, int x, int y, int z) {
        int rad = this.size / 2;
        for (int i = -rad; i <= rad; ++i) {
            for (int j = -rad; j <= rad; ++j) {
                for (int k = 0; k < 3; ++k) {
                    worldObj.func_147465_d(x + i, y + k, z + j, Blocks.field_150350_a, 0, 3);
                }
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("thuttech:blockLift");
        this.icon = iconRegister.func_94245_a("thuttech:liftControl");
        this.icon2 = iconRegister.func_94245_a("thuttech:controlPanel_1");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return par2 == 0 ? this.field_149761_L : (par1 == 3 ? this.icon2 : this.icon);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int x, int y, int z, int par5) {
        int meta = par1IBlockAccess.func_72805_g(x, y, z);
        if (meta == 0) {
            return this.field_149761_L;
        }
        return this.icon;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 1) {
            return new TileEntityLiftAccess();
        }
        return null;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntityLiftAccess controller;
        int meta = par1IBlockAccess.func_72805_g(par2, par3, par4);
        if (meta == 1 && (controller = (TileEntityLiftAccess)par1IBlockAccess.func_147438_o(par2, par3, par4)) != null) {
            boolean cof = controller.called;
            if (controller.lift != null) {
                cof = controller.lift.field_70163_u == (double)(par3 - 2) && controller.lift.getCurrentFloor() == controller.floor;
            }
            return cof ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < 2; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    protected ItemStack func_149644_j(int par1) {
        return new ItemStack((Block)this, 1, par1);
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        return RotationHelper.rotateVanillaBlock((Block)this, (World)worldObj, (int)x, (int)y, (int)z, (ForgeDirection)axis);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityLiftAccess();
    }
}

