/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McBlockPart;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import thut.api.ThutBlocks;
import thut.api.blocks.IRebar;
import thut.api.blocks.multiparts.parts.PartRebar;
import thut.api.render.RenderRebar;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;

public class BlockLiftRail
extends Block
implements ITileEntityProvider,
IRebar {
    public IIcon[] iconArray;
    boolean[] side = new boolean[6];
    public static int MAX_PLACEMENT_RANGE = 64;

    public BlockLiftRail() {
        super(Material.field_151573_f);
        ThutBlocks.liftRail = this;
        this.func_149663_c("liftRail");
        this.func_149647_a(TechCore.tabThut);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        boolean placed = false;
        ItemStack item = player.func_70694_bm();
        BlockCoord pos = new BlockCoord(x, y, z);
        if (item != null) {
            if (!(Block.func_149634_a((Item)item.func_77973_b()) instanceof IRebar)) return false;
            pos = this.placeBlock(world, x, y, z, Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), ForgeDirection.getOrientation((int)side));
            if (pos == null) return placed;
            McBlockPart part = ThutBlocks.getPart(this);
            if (!world.field_72995_K) {
                TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
                if (item.field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, item));
                }
            }
            placed = true;
            if (player.field_71075_bZ.field_75098_d) return placed;
            player.field_71071_by.func_146026_a(item.func_77973_b());
            return placed;
        } else {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null || !(te instanceof TileEntityLiftAccess)) return placed;
            String test = "" + ((TileEntityLiftAccess)te).connectionInfo();
            player.func_145747_a((IChatComponent)new ChatComponentText(test));
        }
        return placed;
    }

    public void func_149743_a(World worldObj, int x, int y, int z, AxisAlignedBB aaBB, List list, Entity par7Entity) {
        this.side = this.sides((IBlockAccess)worldObj, x, y, z);
        if (!(this.side[0] || this.side[1] || this.side[2] || this.side[3] || this.side[4] || this.side[5])) {
            this.side = new boolean[]{true, true, true, true, false, false};
        }
        int n = 5;
        for (ForgeDirection fside : ForgeDirection.VALID_DIRECTIONS) {
            AxisAlignedBB coll = this.getBoundingBoxForSide(fside).func_72317_d((double)x, (double)y, (double)z);
            if (aaBB.func_72326_a(coll) && this.side[n]) {
                list.add(coll);
            }
            --n;
        }
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        this.side = this.sides(par1IBlockAccess, x, y, z);
        if (!(this.side[0] || this.side[1] || this.side[2] || this.side[3] || this.side[4] || this.side[5])) {
            this.side = new boolean[]{false, false, false, false, true, true};
        }
        this.func_149676_a(0.35f, 0.35f, 0.35f, 0.65f, 0.65f, 0.65f);
    }

    public AxisAlignedBB getBoundingBoxForSide(ForgeDirection fside) {
        switch (fside) {
            case UP: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.4f, (double)0.35f, (double)0.65f, (double)1.0, (double)0.65f);
            }
            case DOWN: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.0, (double)0.35f, (double)0.65f, (double)0.6f, (double)0.65f);
            }
            case NORTH: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.35f, (double)0.0, (double)0.65f, (double)0.65f, (double)0.6f);
            }
            case SOUTH: {
                return AxisAlignedBB.func_72330_a((double)0.35f, (double)0.35f, (double)0.4f, (double)0.65f, (double)0.65f, (double)1.0);
            }
            case EAST: {
                return AxisAlignedBB.func_72330_a((double)0.4f, (double)0.35f, (double)0.35f, (double)1.0, (double)0.65f, (double)0.65f);
            }
            case WEST: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.35f, (double)0.35f, (double)0.6f, (double)0.65f, (double)0.65f);
            }
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    private void setBlockBoundsForSide(int x, int y, int z, ForgeDirection side) {
        switch (side) {
            case UP: {
                this.func_149676_a(0.35f, 0.4f, 0.35f, 0.65f, 1.0f, 0.65f);
                break;
            }
            case DOWN: {
                this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.6f, 0.65f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.35f, 0.35f, 0.0f, 0.65f, 0.65f, 0.6f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.35f, 0.35f, 0.4f, 0.65f, 0.65f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.4f, 0.35f, 0.35f, 1.0f, 0.65f, 0.65f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.0f, 0.35f, 0.35f, 0.6f, 0.65f, 0.65f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        boolean placed = false;
        ItemStack item = player.func_70694_bm();
        if (item != null && Block.func_149634_a((Item)item.func_77973_b()) instanceof IRebar) {
            if (player.func_70093_af()) {
                boolean done = false;
                int num = item.field_77994_a;
                while (!done && num > 0) {
                    BlockCoord pos = this.placeBlock(world, x, y, z, Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), ForgeDirection.UP);
                    placed = pos != null;
                    boolean bl = done = !placed;
                    if (placed) {
                        McBlockPart part = ThutBlocks.getPart(this);
                        if (!world.field_72995_K) {
                            TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            --item.field_77994_a;
                            if (item.field_77994_a == 0) {
                                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, item));
                            }
                        }
                        --num;
                    }
                    if (player.field_71075_bZ.field_75098_d) continue;
                    player.field_71071_by.func_146026_a(item.func_77973_b());
                }
            } else {
                BlockCoord pos = this.placeBlock(world, x, y, z, Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), ForgeDirection.UP);
                if (pos != null) {
                    placed = true;
                    McBlockPart part = ThutBlocks.getPart(this);
                    if (!world.field_72995_K) {
                        TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        --item.field_77994_a;
                        if (item.field_77994_a == 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, item));
                        }
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_146026_a(item.func_77973_b());
                    }
                }
            }
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntityLiftAccess controller = (TileEntityLiftAccess)par1IBlockAccess.func_147438_o(par2, par3, par4);
        if (controller != null) {
            return controller.called ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.func_149709_b(par1IBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("thuttech:liftRails");
    }

    @Override
    public boolean[] sides(IBlockAccess worldObj, int x, int y, int z) {
        boolean[] side = new boolean[]{true, true, false, false, false, false};
        return side;
    }

    @Override
    public BlockCoord placeBlock(World worldObj, int x, int y, int z, Block block2, int rebarMeta, ForgeDirection side) {
        if (side != ForgeDirection.UP && side != ForgeDirection.DOWN) {
            return null;
        }
        int dx = side.offsetX;
        int dy = side.offsetY;
        int dz = side.offsetZ;
        BlockCoord ret = new BlockCoord();
        while (Math.abs(dx) < MAX_PLACEMENT_RANGE && Math.abs(dy) < MAX_PLACEMENT_RANGE && Math.abs(dz) < MAX_PLACEMENT_RANGE) {
            if (dy + y > worldObj.func_72940_L()) {
                return null;
            }
            Block block = worldObj.func_147439_a(x + dx, y + dy, z + dz);
            ret.set(x + dx, y + dy, z + dz);
            boolean rightBlock = block2 == block;
            TileMultipart tile = TileMultipart.getOrConvertTile((World)worldObj, (BlockCoord)ret);
            if (tile != null) {
                McBlockPart part;
                boolean placed;
                for (TMultiPart p : tile.partList()) {
                    if (!(p instanceof PartRebar)) continue;
                    rightBlock = true;
                    break;
                }
                if (placed = tile.canAddPart((TMultiPart)(part = ThutBlocks.getPart(this)))) {
                    TileMultipart.addPart((World)worldObj, (BlockCoord)ret, (TMultiPart)part);
                }
            }
            if (block.isAir((IBlockAccess)worldObj, x + dx, y + dy, z + dz) || block.func_149688_o().func_76222_j()) {
                return ret;
            }
            if (!rightBlock) {
                return null;
            }
            dy += side.offsetY;
            dx += side.offsetX;
            dz += side.offsetZ;
        }
        return null;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityLiftAccess();
    }

    @Override
    public IIcon getIcon(Block block) {
        return this.field_149761_L;
    }

    @Override
    public boolean[] getInventorySides() {
        return new boolean[]{false, false, false, false, true, true};
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderRebar.ID;
    }
}

