/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.eventbus.api.Event;
import quarris.enchantability.api.IEffectComponent;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.capabilities.IPlayerEnchant;
import quarris.enchantability.api.enchants.IEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GluttonyEnchantEffect;
import quarris.enchantability.mod.common.util.ModRef;

public class EnchantabilityApi {
    private static IInternals internals = null;
    public static final List<ItemStack> DEXTERITY_ITEMSTACKS = new ArrayList<ItemStack>();
    public static final List<ITag<Item>> DEXTERITY_TAGS = new ArrayList<ITag<Item>>();
    public static final Multimap<Food, BiConsumer<GluttonyEnchantEffect, ItemStack>> GLUTTONY_FOODS = HashMultimap.create();
    @CapabilityInject(value=IPlayerEnchant.class)
    public static Capability<IPlayerEnchant> playerEnchant;

    public static void addToDexterityList(Object ... things) {
        for (Object obj : things) {
            if (obj instanceof Item) {
                DEXTERITY_ITEMSTACKS.add(new ItemStack((IItemProvider)((Item)obj)));
                continue;
            }
            if (obj instanceof Tag) {
                DEXTERITY_TAGS.add((ITag<Item>)((ITag)obj));
                continue;
            }
            ModRef.LOGGER.error("Tried to add an object to the dexterity list of wrong type");
        }
    }

    public static void addToMendingList(Food food, BiConsumer<GluttonyEnchantEffect, ItemStack> action) {
        GLUTTONY_FOODS.put((Object)food, action);
    }

    public static void registerEnchantEffect(ResourceLocation name, Enchantment enchantment, IEffectSupplier effectSupplier) {
        internals.registerEnchantEffect(name, enchantment, effectSupplier);
    }

    public static <F extends IEnchantEffect, T extends Event> void registerEffectComponent(ResourceLocation name, Class<T> eventClass, IEffectComponent<F, T> component, Function<T, Collection<PlayerEntity>> playerGetter) {
        internals.registerEffectComponent(name, eventClass, component, playerGetter);
    }

    public static List<IEffectSupplier> getEnchantEffects(Enchantment enchantment) {
        return internals.getEnchantEffects(enchantment);
    }

    public static IEffectSupplier getEnchantEffect(ResourceLocation name) {
        return internals.getEnchantEffect(name);
    }

    @Deprecated
    public static IInternals getInternals() {
        if (internals == null) {
            throw new NullPointerException("EnchantabilityAPI: The instance was accessed before it was initialised.");
        }
        return internals;
    }

    public static void setInternals(IInternals inst) {
        if (internals == null) {
            internals = inst;
        }
    }

    public static interface IInternals {
        public void registerEnchantEffect(ResourceLocation var1, Enchantment var2, IEffectSupplier var3);

        public <F extends IEnchantEffect, T extends Event> void registerEffectComponent(ResourceLocation var1, Class<T> var2, IEffectComponent<F, T> var3, Function<T, Collection<PlayerEntity>> var4);

        public List<IEffectSupplier> getEnchantEffects(Enchantment var1);

        public IEffectSupplier getEnchantEffect(ResourceLocation var1);
    }
}

