/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.mod.common.util.ModRef;

public class ModConfig {
    public ForgeConfigSpec.IntValue buttonXOffset;
    public ForgeConfigSpec.IntValue buttonYOffset;
    public ForgeConfigSpec.BooleanValue enableAdrenaline;
    public ForgeConfigSpec.BooleanValue enableAirWalker;
    public ForgeConfigSpec.BooleanValue enableBlastResist;
    public ForgeConfigSpec.BooleanValue enableDeflection;
    public ForgeConfigSpec.BooleanValue enableDexterity;
    public ForgeConfigSpec.BooleanValue enableFarReach;
    public ForgeConfigSpec.BooleanValue enableFastBreak;
    public ForgeConfigSpec.BooleanValue enableFirePraise;
    public ForgeConfigSpec.BooleanValue enableGluttony;
    public ForgeConfigSpec.BooleanValue enableGravity;
    public ForgeConfigSpec.BooleanValue enableHeat;
    public ForgeConfigSpec.BooleanValue enableLoyalty;
    public ForgeConfigSpec.BooleanValue enableLure;
    public ForgeConfigSpec.BooleanValue enableMetalFist;
    public ForgeConfigSpec.BooleanValue enableSmite;
    public ForgeConfigSpec.BooleanValue enableStrike;
    public ForgeConfigSpec.BooleanValue enableSwiftCharge;
    public ForgeConfigSpec.BooleanValue enableVoid;
    public ForgeConfigSpec.IntValue adrenalineCooldown;
    public ForgeConfigSpec.IntValue adrenalineDamageTakenTime;
    public ForgeConfigSpec.IntValue adrenalineDamageDealtTime;
    public ForgeConfigSpec.DoubleValue adrenalineDamageTakenThreshold;
    public ForgeConfigSpec.DoubleValue adrenalineDamageDealtThreshold;
    public ForgeConfigSpec.IntValue adrenalineDuration1;
    public ForgeConfigSpec.IntValue adrenalineDuration2;
    public ForgeConfigSpec.IntValue adrenalineDuration3;
    public ForgeConfigSpec.ConfigValue<List<String>> dexterityTags;
    public ForgeConfigSpec.ConfigValue<List<String>> dexterityItems;
    public ForgeConfigSpec.BooleanValue enableCookie;
    public ForgeConfigSpec.BooleanValue enableRabbitStew;
    public ForgeConfigSpec.IntValue additionalTickSpeed;
    public ForgeConfigSpec.IntValue heatRange;
    public ForgeConfigSpec.BooleanValue treatBlacklistAsWhitelist;
    public ForgeConfigSpec.ConfigValue<List<String>> tileBlacklist;
    public ForgeConfigSpec.ConfigValue<List<Integer>> loyaltyReviveTimes;
    public ForgeConfigSpec.DoubleValue speedMultiplier;
    private static ModConfig instance;

    public static ModConfig get() {
        return instance;
    }

    public static void init(ForgeConfigSpec.Builder builder) {
        instance = new ModConfig(builder);
    }

    public ModConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Misc Configs").push("misc");
        this.buttonXOffset = builder.comment("The horizontal offset for the button").defineInRange("buttonXOffset", -18, -1000, 1000);
        this.buttonYOffset = builder.comment("The vertical offset for the button").defineInRange("buttonYOffset", 143, -1000, 1000);
        builder.pop();
        builder.comment("Enabled Features").push("features");
        this.enableAdrenaline = builder.define("enableAdrenaline", true);
        this.enableAirWalker = builder.define("enableAirWalker", true);
        this.enableBlastResist = builder.define("enableBlastResist", true);
        this.enableDeflection = builder.define("enableDeflection", false);
        this.enableDexterity = builder.define("enableDexterity", true);
        this.enableFarReach = builder.define("enableFarReach", true);
        this.enableFastBreak = builder.define("enableFastBreak", true);
        this.enableFirePraise = builder.define("enableFirePraise", true);
        this.enableGluttony = builder.define("enableGluttony", true);
        this.enableGravity = builder.define("enableGravity", true);
        this.enableHeat = builder.define("enableHeat", true);
        this.enableLure = builder.define("enableLure", false);
        this.enableLoyalty = builder.define("enableLoyalty", true);
        this.enableMetalFist = builder.define("enableMetalFist", true);
        this.enableSmite = builder.define("enableSmite", true);
        this.enableStrike = builder.define("enableStrike", true);
        this.enableSwiftCharge = builder.define("enableSwiftCharge", true);
        this.enableVoid = builder.define("enableVoid", true);
        builder.pop();
        builder.comment("Enchant Configs").push("enchants");
        builder.comment("Adrenaline").push("adrenaline");
        this.adrenalineCooldown = builder.comment("The cooldown (in ticks) after the adrenaline has worn off").defineInRange("adrenalineCooldown", 600, 0, 72000);
        this.adrenalineDamageTakenTime = builder.comment("The time (in ticks) to track the damage dealt for the corresponding threshold for activation").defineInRange("adrenalineDamageTakenTime", 80, 10, Integer.MAX_VALUE);
        this.adrenalineDamageDealtTime = builder.comment("The time (in ticks) to track the damage taken for the corresponding threshold for activation").defineInRange("adrenalineDamageDealtTime", 40, 10, Integer.MAX_VALUE);
        this.adrenalineDamageTakenThreshold = builder.comment("The damage needed to be taken within the tracked time to activate").defineInRange("adrenalineDamageTakenThreshold", 12.0, 1.0, 100.0);
        this.adrenalineDamageDealtThreshold = builder.comment("The damage needed to be dealt within the tracked time to activate").defineInRange("adrenalineDamageDealtThreshold", 50.0, 1.0, 2000.0);
        builder.comment("Duration (in ticks) for the effects of Adrenaline per level of enchant");
        this.adrenalineDuration1 = builder.defineInRange("adrenalineDuration1", 100, 1, 12000);
        this.adrenalineDuration2 = builder.defineInRange("adrenalineDuration2", 300, 1, 12000);
        this.adrenalineDuration3 = builder.defineInRange("adrenalineDuration3", 800, 1, 12000);
        builder.pop();
        builder.comment("Dexterity").push("dexterity");
        this.dexterityTags = builder.define("dexterityTags", ModConfig.defaultTags());
        this.dexterityItems = builder.define("dexterityItems", ModConfig.defaultItems());
        builder.pop();
        builder.comment("Gluttony").push("gluttony");
        this.enableRabbitStew = builder.define("enableRabbitStew", true);
        this.enableCookie = builder.define("enableCookie", true);
        builder.pop();
        builder.comment("Heat").push("heat");
        this.additionalTickSpeed = builder.defineInRange("additionalTickSpeed", 3, 1, 64);
        this.heatRange = builder.defineInRange("heatRange", 32, 1, 256);
        this.treatBlacklistAsWhitelist = builder.define("treatBlacklistAsWhitelist", false);
        this.tileBlacklist = builder.define("tileBlacklist", ModConfig.defaultTileBlacklist());
        builder.pop();
        builder.comment("Loyalty").push("loyalty");
        this.loyaltyReviveTimes = builder.comment(new String[]{"Time (in ticks) until the pet revives", "Times for level 1/2/3 is represented as [1, 2, 3]"}).define("reviveTimes", ModConfig.defaultLoyaltyReviveTimes());
        builder.pop();
        builder.comment("Metal Fist").push("metal_fist");
        this.speedMultiplier = builder.comment(new String[]{"The multiplier for the break speed when wearing Sharpness 5+ book", "Set to '1.0' to disable increased speed on Sharpness 5"}).defineInRange("speedMultiplier", 2.0, 1.0, 10.0);
        builder.pop();
        builder.pop();
    }

    public void reloadTags() {
        for (String itemName : (List)this.dexterityItems.get()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item != null) {
                EnchantabilityApi.addToDexterityList(item);
                continue;
            }
            ModRef.LOGGER.warn("Registered item for dexterity doesn't exist, " + itemName);
        }
        for (String tagName : (List)this.dexterityTags.get()) {
            ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(tagName));
            if (tag != null) {
                EnchantabilityApi.addToDexterityList(tag);
                continue;
            }
            ModRef.LOGGER.warn("Registered tag for dexterity doesn't exist, " + tagName);
        }
    }

    private static List<Integer> defaultLoyaltyReviveTimes() {
        ArrayList<Integer> defaults = new ArrayList<Integer>(3);
        defaults.add(1200);
        defaults.add(900);
        defaults.add(600);
        return defaults;
    }

    private static List<String> defaultTags() {
        ITag.INamedTag[] tags = new ITag.INamedTag[]{Tags.Items.SANDSTONE, Tags.Items.RODS_WOODEN, ItemTags.field_219772_G, Tags.Items.DYES, ItemTags.field_199905_b, ItemTags.field_219776_M, ItemTags.field_219773_J, ItemTags.field_219770_E, ItemTags.field_200034_d, ItemTags.field_202900_j, ItemTags.field_203444_y, Tags.Items.CHESTS, Tags.Items.LEATHER};
        return Arrays.stream(tags).map(tag -> tag.func_230234_a_().toString()).collect(Collectors.toList());
    }

    private static List<String> defaultItems() {
        Item[] items = new Item[]{Items.field_151059_bz, Items.field_151102_aT, Items.field_196153_dF, Items.field_151025_P};
        return Arrays.stream(items).map(item -> item.getRegistryName().toString()).collect(Collectors.toList());
    }

    private static List<String> defaultTileBlacklist() {
        TileEntityType[] types = new TileEntityType[]{TileEntityType.field_200987_r, TileEntityType.field_200980_k, TileEntityType.field_200984_o, TileEntityType.field_205166_z, TileEntityType.field_222486_D, TileEntityType.field_226985_G_, TileEntityType.field_200986_q, TileEntityType.field_200991_v};
        List<String> list = Arrays.stream(types).map(type -> type.getRegistryName().toString()).collect(Collectors.toList());
        list.add("enchantability:air");
        return list;
    }
}

