/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.client;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.client.screen.EnchButton;
import quarris.enchantability.mod.common.enchants.EnchantEffectRegistry;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="enchantability")
public class ClientEvents {
    public static boolean isEnderOpen;
    public static double clickMouseX;
    public static double clickMouseY;

    @SubscribeEvent
    public static void addEnchantButton(GuiScreenEvent.InitGuiEvent.Post event) {
        if (isEnderOpen && event.getGui() instanceof ChestScreen) {
            ChestScreen screen = (ChestScreen)event.getGui();
            event.addWidget((Widget)new EnchButton(screen.getGuiLeft() + (Integer)ModConfig.get().buttonXOffset.get(), screen.getGuiTop() + (Integer)ModConfig.get().buttonYOffset.get(), false));
        }
    }

    @SubscribeEvent
    public static void addEnchantTooltips(ItemTooltipEvent event) {
        if (!(event.getItemStack().func_77973_b() instanceof EnchantedBookItem)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        ArrayList tooltips = new ArrayList();
        Set enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        for (Enchantment enchantment : enchantments) {
            tooltips.addAll(EnchantEffectRegistry.BY_ENCHANTMENT.get((Object)enchantment).stream().map(EnchantEffectRegistry.DESCRIPTIONS::get).collect(Collectors.toList()));
        }
        if (tooltips.isEmpty()) {
            event.getToolTip().add(new TranslationTextComponent("enchant.desc.empty").func_240699_a_(TextFormatting.GRAY));
            return;
        }
        if (player == null) {
            event.getToolTip().add(new StringTextComponent("Enchantability:"));
            for (ITextComponent tooltip : tooltips) {
                StringTextComponent text = new StringTextComponent(" - ");
                text.func_230529_a_(tooltip);
                event.getToolTip().add(text);
            }
        } else if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
            event.getToolTip().add(new StringTextComponent("Enchantability:").func_240699_a_(TextFormatting.GOLD));
            for (ITextComponent tooltip : tooltips) {
                IFormattableTextComponent text = new StringTextComponent(" - ").func_240699_a_(TextFormatting.BLUE);
                text.func_230529_a_(tooltip);
                event.getToolTip().add(text);
            }
        } else {
            event.getToolTip().add(new TranslationTextComponent("enchant.desc.short").func_240699_a_(TextFormatting.GRAY));
        }
    }
}

