/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.capabilities;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.capabilities.IPlayerEnchant;
import quarris.enchantability.api.enchants.IEnchantEffect;
import quarris.enchantability.mod.common.enchants.EnchantEffectRegistry;

public class PlayerEnchant
extends ItemStackHandler
implements IPlayerEnchant {
    public static final int ENCHANT_SLOT_SIZE = 4;
    public static final int EXTENDED_ENCHANT_SLOT_SIZE = 5;
    private final List<IEnchantEffect> effects = new ArrayList<IEnchantEffect>();
    public PlayerEntity player;
    public boolean isExtended;
    private boolean dirty;

    public PlayerEnchant(PlayerEntity player) {
        super(4);
        this.player = player;
        this.isExtended = false;
    }

    @Override
    public List<IEnchantEffect> getEnchants() {
        return this.effects;
    }

    @Override
    public boolean hasEnchant(ResourceLocation name) {
        return this.getEnchants().stream().anyMatch(effect -> name.equals((Object)effect.getName()));
    }

    @Override
    public IEnchantEffect getEnchant(ResourceLocation name) {
        return this.getEnchants().stream().filter(effect -> name.equals((Object)effect.getName())).findFirst().orElse(null);
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public ItemStack setExtended(boolean extended) {
        if (this.isExtended == extended) {
            return ItemStack.field_190927_a;
        }
        this.markDirty(true);
        this.isExtended = extended;
        NonNullList current = this.stacks;
        if (extended) {
            this.setSize(5);
        } else {
            this.setSize(4);
        }
        int currSize = Math.min(current.size(), this.stacks.size());
        for (int i = 0; i < currSize; ++i) {
            this.setStackInSlot(i, (ItemStack)current.get(i));
        }
        return extended ? ItemStack.field_190927_a : (ItemStack)current.get(4);
    }

    @Override
    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof EnchantedBookItem)) {
            return false;
        }
        ListNBT enchants = EnchantedBookItem.func_92110_g((ItemStack)stack);
        return enchants.size() >= 1;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == EnchantabilityApi.playerEnchant ? LazyOptional.of(() -> this) : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        this.serializeEffects(nbt);
        nbt.func_74757_a("Extended", this.isExtended);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.deserializeEffects(nbt);
        this.isExtended = nbt.func_74767_n("Extended");
        super.deserializeNBT(nbt);
    }

    @Override
    public CompoundNBT serializeEffects(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (IEnchantEffect effect : this.getEnchants()) {
            list.add((Object)effect.serializeNBT());
        }
        nbt.func_218657_a("Effects", (INBT)list);
        return nbt;
    }

    @Override
    public void deserializeEffects(CompoundNBT nbt) {
        this.getEnchants().clear();
        List tags = nbt.func_150295_c("Effects", 10).stream().map(tag -> (CompoundNBT)tag).collect(Collectors.toList());
        for (CompoundNBT tag2 : tags) {
            ResourceLocation name = new ResourceLocation(tag2.func_74779_i("Name"));
            int level = tag2.func_74762_e("Level");
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(tag2.func_74779_i("Enchantment")));
            IEffectSupplier supplier = EnchantEffectRegistry.getEffect(name);
            if (supplier == null) continue;
            IEnchantEffect effect = supplier.create(this.getPlayer(), enchantment, level);
            effect.deserializeNBT(tag2);
            this.getEnchants().add(effect);
        }
    }
}

