/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.content;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.capabilities.IPlayerEnchant;

public class WitherHeartItem
extends Item {
    @ObjectHolder(value="enchantability:wither_heart")
    public static Item WITHER_HEART;
    public static Food witherHeartFood;

    public WitherHeartItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_200917_a(1).func_221540_a(witherHeartFood).func_208103_a(Rarity.EPIC));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (((IPlayerEnchant)player.getCapability(EnchantabilityApi.playerEnchant).orElseGet(null)).isExtended()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("wither_heart.already_eaten"), true);
            return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (stack.func_77978_p() == null || player.func_110124_au().equals(stack.func_77978_p().func_186857_a("Owner"))) {
                player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> cap.setExtended(true));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("wither_heart.eaten"), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("wither_heart.not_worthy").func_240699_a_(TextFormatting.RED), true);
            }
        }
        return super.func_77654_b(stack, worldIn, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent translation;
        if (stack.func_77973_b() != WITHER_HEART) {
            return;
        }
        if (stack.func_77978_p() == null) {
            translation = new TranslationTextComponent("wither_heart.tooltip.no_owner");
        } else {
            UUID ownerUUID;
            UUID uUID = ownerUUID = stack.func_77978_p().func_74764_b("Owner") ? stack.func_77978_p().func_186857_a("Owner") : null;
            String ownerName = stack.func_77978_p().func_74764_b("OwnerName") ? stack.func_77978_p().func_74779_i("OwnerName") : "Unknown" + (ownerUUID == null ? "" : "{" + ownerUUID + "}");
            translation = new TranslationTextComponent("wither_heart.tooltip.heart_owner", new Object[]{ownerName});
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("wither_heart.tooltip.only_worthy").func_240699_a_(TextFormatting.RED));
        tooltip.add((ITextComponent)translation.func_240699_a_(TextFormatting.WHITE));
    }

    static {
        witherHeartFood = new Food.Builder().func_221455_b().func_221453_d();
    }
}

