/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.IEffectComponent;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.enchants.IEnchantEffect;
import quarris.enchantability.mod.Enchantability;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.compat.CompatManager;
import quarris.enchantability.mod.common.enchants.impl.AdrenalineEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.AirWalkerEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.BlastResistanceEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.DeflectionEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.DexterityEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FarReachEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FastBreakEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FirePraiseEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GluttonyEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GravityEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.HeatEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.LoyaltyEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.LureEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.MetalFistEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.SmiteEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.StrikeEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.SwiftChargeEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.VoidEnchantEffect;

public class Enchants {
    public static void registerEffect() {
        ModConfig config = ModConfig.get();
        CompatManager.setPatchouliFlag(AdrenalineEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableAdrenaline.get());
        if (((Boolean)config.enableAdrenaline.get()).booleanValue()) {
            Enchants.registerEffect(AdrenalineEnchantEffect.NAME, Enchantments.field_185298_f, AdrenalineEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(AirWalkerEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableAirWalker.get());
        if (((Boolean)config.enableAirWalker.get()).booleanValue()) {
            Enchants.registerEffect(AirWalkerEnchantEffect.NAME, Enchantments.field_185301_j, AirWalkerEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(BlastResistanceEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableBlastResist.get());
        if (((Boolean)config.enableBlastResist.get()).booleanValue()) {
            Enchants.registerEffect(BlastResistanceEnchantEffect.NAME, Enchantments.field_185297_d, BlastResistanceEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(DeflectionEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableDeflection.get());
        if (((Boolean)config.enableDeflection.get()).booleanValue()) {
            Enchants.registerEffect(DeflectionEnchantEffect.NAME, Enchantments.field_180308_g, DeflectionEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(DexterityEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableDexterity.get());
        if (((Boolean)config.enableDexterity.get()).booleanValue()) {
            Enchants.registerEffect(DexterityEnchantEffect.NAME, Enchantments.field_185305_q, DexterityEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(FarReachEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableFarReach.get());
        if (((Boolean)config.enableFarReach.get()).booleanValue()) {
            Enchants.registerEffect(FarReachEnchantEffect.NAME, Enchantments.field_180313_o, FarReachEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(FastBreakEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableFastBreak.get());
        if (((Boolean)config.enableFastBreak.get()).booleanValue()) {
            Enchants.registerEffect(FastBreakEnchantEffect.NAME, Enchantments.field_185310_v, FastBreakEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(FirePraiseEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableFirePraise.get());
        if (((Boolean)config.enableFirePraise.get()).booleanValue()) {
            Enchants.registerEffect(FirePraiseEnchantEffect.NAME, Enchantments.field_77329_d, FirePraiseEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(GluttonyEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableGluttony.get());
        if (((Boolean)config.enableGluttony.get()).booleanValue()) {
            Enchants.registerEffect(GluttonyEnchantEffect.NAME, Enchantments.field_185296_A, GluttonyEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(GravityEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableGravity.get());
        if (((Boolean)config.enableGravity.get()).booleanValue()) {
            Enchants.registerEffect(GravityEnchantEffect.NAME, Enchantments.field_180309_e, GravityEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(HeatEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableHeat.get());
        if (((Boolean)config.enableHeat.get()).booleanValue()) {
            Enchants.registerEffect(HeatEnchantEffect.NAME, Enchantments.field_185311_w, HeatEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(LoyaltyEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableLoyalty.get());
        if (((Boolean)config.enableLoyalty.get()).booleanValue()) {
            Enchants.registerEffect(LoyaltyEnchantEffect.NAME, Enchantments.field_203193_C, LoyaltyEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(LureEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableLure.get());
        if (((Boolean)config.enableLure.get()).booleanValue()) {
            Enchants.registerEffect(LureEnchantEffect.NAME, Enchantments.field_151369_A, LureEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(MetalFistEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableMetalFist.get());
        if (((Boolean)config.enableMetalFist.get()).booleanValue()) {
            Enchants.registerEffect(MetalFistEnchantEffect.NAME, Enchantments.field_185302_k, MetalFistEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(SmiteEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableSmite.get());
        if (((Boolean)config.enableSmite.get()).booleanValue()) {
            Enchants.registerEffect(SmiteEnchantEffect.NAME, Enchantments.field_185303_l, SmiteEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(StrikeEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableStrike.get());
        if (((Boolean)config.enableStrike.get()).booleanValue()) {
            Enchants.registerEffect(StrikeEnchantEffect.NAME, Enchantments.field_185309_u, StrikeEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(SwiftChargeEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableSwiftCharge.get());
        if (((Boolean)config.enableSwiftCharge.get()).booleanValue()) {
            Enchants.registerEffect(SwiftChargeEnchantEffect.NAME, Enchantments.field_222193_H, SwiftChargeEnchantEffect::new);
        }
        CompatManager.setPatchouliFlag(VoidEnchantEffect.NAME.func_110623_a(), (Boolean)config.enableVoid.get());
        if (((Boolean)config.enableVoid.get()).booleanValue()) {
            Enchants.registerEffect(VoidEnchantEffect.NAME, Enchantments.field_185312_x, VoidEnchantEffect::new);
        }
        Enchantability.proxy.registerClientComponents();
        if (((Boolean)config.enableAdrenaline.get()).booleanValue()) {
            Enchants.registerComponent(AdrenalineEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, AdrenalineEnchantEffect::tick, e -> Collections.singleton(e.player));
            Enchants.registerComponent(AdrenalineEnchantEffect.NAME, LivingDamageEvent.class, AdrenalineEnchantEffect::onDamageTaken, e -> e.getEntityLiving() instanceof PlayerEntity ? Collections.singleton((PlayerEntity)e.getEntityLiving()) : null);
            Enchants.registerComponent(AdrenalineEnchantEffect.NAME, LivingAttackEvent.class, AdrenalineEnchantEffect::onDamageDealt, e -> {
                Entity entity;
                if (e.getSource() instanceof EntityDamageSource && (entity = e.getSource().func_76346_g()) instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)entity);
                }
                return null;
            });
        }
        if (((Boolean)config.enableAirWalker.get()).booleanValue()) {
            Enchants.registerComponent(AirWalkerEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, AirWalkerEnchantEffect::airWalk, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableBlastResist.get()).booleanValue()) {
            Enchants.registerComponent(BlastResistanceEnchantEffect.NAME, ExplosionEvent.Detonate.class, BlastResistanceEnchantEffect::resistBlast, evt -> evt.getAffectedEntities().stream().filter(entity -> entity instanceof PlayerEntity).map(entity -> (PlayerEntity)entity).collect(Collectors.toList()));
        }
        if (((Boolean)config.enableDeflection.get()).booleanValue()) {
            Enchants.registerComponent(DeflectionEnchantEffect.NAME, ProjectileImpactEvent.class, DeflectionEnchantEffect::deflect, e -> {
                if (e.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a());
                }
                return null;
            });
        }
        if (((Boolean)config.enableDexterity.get()).booleanValue()) {
            Enchants.registerComponent(DexterityEnchantEffect.NAME, PlayerEvent.ItemCraftedEvent.class, DexterityEnchantEffect::craft, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableFastBreak.get()).booleanValue()) {
            Enchants.registerComponent(FastBreakEnchantEffect.NAME, PlayerEvent.BreakSpeed.class, FastBreakEnchantEffect::handBreak, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableFirePraise.get()).booleanValue()) {
            Enchants.registerComponent(FirePraiseEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, FirePraiseEnchantEffect::praiseTheSun, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableGluttony.get()).booleanValue()) {
            Enchants.registerComponent(GluttonyEnchantEffect.NAME, LivingEntityUseItemEvent.Finish.class, GluttonyEnchantEffect::consume, e -> e.getEntity() instanceof PlayerEntity ? Collections.singleton((PlayerEntity)e.getEntity()) : Collections.emptyList());
            GluttonyEnchantEffect.GluttonyFoods.initMendingFoods();
        }
        if (((Boolean)config.enableGravity.get()).booleanValue()) {
            Enchants.registerComponent(GravityEnchantEffect.NAME, LivingFallEvent.class, GravityEnchantEffect::reduceFallDamage, e -> e.getEntity() instanceof PlayerEntity ? Collections.singleton((PlayerEntity)e.getEntity()) : Collections.emptyList());
        }
        if (((Boolean)config.enableHeat.get()).booleanValue()) {
            Enchants.registerComponent(HeatEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, HeatEnchantEffect::heat, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableLoyalty.get()).booleanValue()) {
            Enchants.registerComponent(LoyaltyEnchantEffect.NAME, LivingDeathEvent.class, LoyaltyEnchantEffect::petDied, e -> {
                TameableEntity pet;
                if (e.getEntityLiving() instanceof TameableEntity && (pet = (TameableEntity)e.getEntityLiving()).func_70902_q() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)pet.func_70902_q());
                }
                return Collections.emptyList();
            });
            Enchants.registerComponent(LoyaltyEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, LoyaltyEnchantEffect::revivePet, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableLure.get()).booleanValue()) {
            Enchants.registerComponent(LureEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, LureEnchantEffect::spawnAnimals, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableMetalFist.get()).booleanValue()) {
            Enchants.registerComponent(MetalFistEnchantEffect.NAME, PlayerEvent.HarvestCheck.class, MetalFistEnchantEffect::harvestCheck, e -> Collections.singleton(e.getPlayer()));
            Enchants.registerComponent(MetalFistEnchantEffect.NAME, PlayerEvent.BreakSpeed.class, MetalFistEnchantEffect::breakSpeed, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableSmite.get()).booleanValue()) {
            Enchants.registerComponent(SmiteEnchantEffect.NAME, AttackEntityEvent.class, SmiteEnchantEffect::smite, e -> Collections.singleton(e.getPlayer()));
            Enchants.registerComponent(SmiteEnchantEffect.NAME, EntityStruckByLightningEvent.class, SmiteEnchantEffect::avoidPlayer, e -> {
                if (e.getEntity() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)e.getEntity());
                }
                return Collections.emptyList();
            });
        }
        if (((Boolean)config.enableStrike.get()).booleanValue()) {
            Enchants.registerComponent(StrikeEnchantEffect.NAME, LivingHurtEvent.class, StrikeEnchantEffect::strike, e -> {
                if (e.getSource().field_76373_n.equals("player")) {
                    return Collections.singleton((PlayerEntity)e.getSource().func_76346_g());
                }
                return Collections.emptyList();
            });
        }
        if (((Boolean)config.enableSwiftCharge.get()).booleanValue()) {
            Enchants.registerComponent(SwiftChargeEnchantEffect.NAME, LivingEntityUseItemEvent.Start.class, SwiftChargeEnchantEffect::itemUse, e -> {
                if (e.getEntity() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)e.getEntity());
                }
                return Collections.emptyList();
            });
            Enchants.registerComponent(SwiftChargeEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, SwiftChargeEnchantEffect::transition, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableVoid.get()).booleanValue()) {
            Enchants.registerComponent(VoidEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, VoidEnchantEffect::voidTeleport, e -> Collections.singleton(e.player));
        }
    }

    private static void registerEffect(ResourceLocation name, Enchantment enchantment, IEffectSupplier effectSupplier) {
        EnchantabilityApi.registerEnchantEffect(name, enchantment, effectSupplier);
    }

    private static <F extends IEnchantEffect, T extends Event> void registerComponent(ResourceLocation name, Class<T> eventClass, IEffectComponent<F, T> component, Function<T, Collection<PlayerEntity>> playerGetter) {
        EnchantabilityApi.registerEffectComponent(name, eventClass, component, playerGetter);
    }
}

