/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.LogicalSide;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.util.ModRef;

public class AdrenalineEnchantEffect
extends AbstractEnchantEffect {
    public static final ResourceLocation NAME = ModRef.createRes("adrenaline");
    public int cooldown;
    public final Map<Long, Float> damageTaken = new HashMap<Long, Float>();
    public final Map<Long, Float> damageDealt = new HashMap<Long, Float>();

    public AdrenalineEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    public static void tick(AdrenalineEnchantEffect effect, TickEvent.PlayerTickEvent event) {
        long tick;
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER) {
            return;
        }
        if (effect.cooldown > 0) {
            --effect.cooldown;
            if (effect.cooldown == 0) {
                effect.player.func_146105_b((ITextComponent)new TranslationTextComponent("enchantability:adrenaline.enchant.ready"), true);
            }
            return;
        }
        long time = event.player.field_70170_p.func_82737_E();
        List sorted = effect.damageDealt.keySet().stream().sorted().collect(Collectors.toList());
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext() && time >= (tick = ((Long)iterator.next()).longValue()) + (long)((Integer)ModConfig.get().adrenalineDamageDealtTime.get()).intValue()) {
            effect.damageDealt.remove(tick);
        }
        sorted = effect.damageTaken.keySet().stream().sorted().collect(Collectors.toList());
        iterator = sorted.iterator();
        while (iterator.hasNext() && time >= (tick = ((Long)iterator.next()).longValue()) + (long)((Integer)ModConfig.get().adrenalineDamageTakenTime.get()).intValue()) {
            effect.damageTaken.remove(tick);
        }
        boolean activated = false;
        if ((double)AdrenalineEnchantEffect.sum(effect.damageTaken) > (Double)ModConfig.get().adrenalineDamageTakenThreshold.get()) {
            AdrenalineEnchantEffect.damageTakenBoost(effect.level(), effect.player);
            activated = true;
        }
        if ((double)AdrenalineEnchantEffect.sum(effect.damageDealt) > (Double)ModConfig.get().adrenalineDamageDealtThreshold.get()) {
            AdrenalineEnchantEffect.damageDealtBoost(effect.level(), effect.player);
            activated = true;
        }
        if (activated) {
            effect.player.func_146105_b((ITextComponent)new TranslationTextComponent("enchantability:adrenaline.enchant.activated"), true);
            effect.cooldown = AdrenalineEnchantEffect.durationFromLevel(effect.level()) + (Integer)ModConfig.get().adrenalineCooldown.get();
            effect.damageTaken.clear();
            effect.damageDealt.clear();
        }
    }

    public static void onDamageTaken(AdrenalineEnchantEffect effect, LivingDamageEvent event) {
        if (effect.cooldown > 0 || (double)event.getAmount() < 0.001) {
            return;
        }
        effect.damageTaken.put(event.getEntityLiving().field_70170_p.func_82737_E(), Float.valueOf(event.getAmount()));
    }

    private static void damageTakenBoost(int level, PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, AdrenalineEnchantEffect.durationFromLevel(level) / 4, level - 1, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76424_c, AdrenalineEnchantEffect.durationFromLevel(level), level - 1, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76430_j, AdrenalineEnchantEffect.durationFromLevel(level), level - 1, false, false));
    }

    public static void onDamageDealt(AdrenalineEnchantEffect effect, LivingAttackEvent event) {
        if (effect.cooldown > 0 || (double)event.getAmount() < 0.001) {
            return;
        }
        effect.damageDealt.put(event.getEntityLiving().field_70170_p.func_82737_E(), Float.valueOf(event.getAmount()));
    }

    private static void damageDealtBoost(int level, PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, AdrenalineEnchantEffect.durationFromLevel(level), level - 1, false, false));
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, AdrenalineEnchantEffect.durationFromLevel(level), level - 1, false, false));
    }

    private static int durationFromLevel(int level) {
        if (level == 1) {
            return (Integer)ModConfig.get().adrenalineDuration1.get();
        }
        if (level == 2) {
            return (Integer)ModConfig.get().adrenalineDuration2.get();
        }
        return (Integer)ModConfig.get().adrenalineDuration3.get();
    }

    private static float sum(Map<Long, Float> map) {
        float sum = 0.0f;
        for (float val : map.values()) {
            sum += val;
        }
        return sum;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("Cooldown", this.cooldown);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.cooldown = nbt.func_74762_e("Cooldown");
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

