/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.common.util.ModRef;
import quarris.enchantability.mod.common.util.ModUtil;

public class DexterityEnchantEffect
extends AbstractEnchantEffect {
    public static final ResourceLocation NAME = ModRef.createRes("dexterity");

    public DexterityEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    public static void craft(DexterityEnchantEffect effect, PlayerEvent.ItemCraftedEvent event) {
        PlayerEntity player = effect.player;
        if (!player.field_70170_p.func_201670_d()) {
            ItemStack output = event.getCrafting();
            float chance = (float)effect.level() * 0.0375f;
            if (chance >= ModUtil.RANDOM.nextFloat()) {
                for (ItemStack itemStack : EnchantabilityApi.DEXTERITY_ITEMSTACKS) {
                    if (!ItemStack.func_179545_c((ItemStack)output, (ItemStack)itemStack)) continue;
                    ItemStack copy = output.func_77946_l();
                    copy.func_190920_e(1);
                    ItemEntity item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), copy);
                    item.func_174868_q();
                    player.field_70170_p.func_217376_c((Entity)item);
                    if (ModUtil.RANDOM.nextFloat() >= chance) {
                        player.func_195068_e(effect.level());
                    }
                    return;
                }
                for (ITag iTag : EnchantabilityApi.DEXTERITY_TAGS) {
                    if (!iTag.func_230235_a_((Object)output.func_77973_b())) continue;
                    ItemStack copy = output.func_77946_l();
                    copy.func_190920_e(1);
                    ItemEntity item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), copy);
                    item.func_174868_q();
                    player.field_70170_p.func_217376_c((Entity)item);
                    if (ModUtil.RANDOM.nextFloat() >= chance) {
                        player.func_195068_e(effect.level());
                    }
                    return;
                }
            }
        }
    }

    public static void addTooltips(DexterityEnchantEffect effect, ItemTooltipEvent event) {
        boolean shouldAddTooltip = false;
        for (ItemStack itemStack : EnchantabilityApi.DEXTERITY_ITEMSTACKS) {
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)event.getItemStack())) continue;
            shouldAddTooltip = true;
            break;
        }
        if (!shouldAddTooltip) {
            for (ITag iTag : EnchantabilityApi.DEXTERITY_TAGS) {
                if (!iTag.func_230235_a_((Object)event.getItemStack().func_77973_b())) continue;
                shouldAddTooltip = true;
                break;
            }
        }
        if (shouldAddTooltip) {
            event.getToolTip().add(new TranslationTextComponent("dexterity.tooltip"));
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

