/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.util.ModRef;

public class HeatEnchantEffect
extends AbstractEnchantEffect {
    public static final ResourceLocation NAME = ModRef.createRes("heat");

    public HeatEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    public static void heat(HeatEnchantEffect effect, TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            PlayerEntity player = effect.player;
            ServerWorld world = (ServerWorld)player.field_70170_p;
            ModConfig config = ModConfig.get();
            int ticks = (Integer)config.additionalTickSpeed.get();
            List tileBlacklist = (List)config.tileBlacklist.get();
            boolean treatAsWhitelist = (Boolean)config.treatBlacklistAsWhitelist.get();
            List<TileEntity> tiles = HeatEnchantEffect.getTileEntitiesInArea((IWorld)world, player.func_233580_cy_(), (Integer)ModConfig.get().heatRange.get());
            for (TileEntity tile : tiles) {
                if (!(tile instanceof ITickableTileEntity) || treatAsWhitelist != tileBlacklist.contains(tile.func_200662_C().getRegistryName().toString())) continue;
                for (int i = 0; i < ticks; ++i) {
                    ((ITickableTileEntity)tile).func_73660_a();
                }
            }
        }
    }

    private static List<TileEntity> getTileEntitiesInArea(IWorld world, BlockPos pos, int radius) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (int x = pos.func_177958_n() - radius >> 4; x <= pos.func_177958_n() + radius >> 4; ++x) {
            for (int z = pos.func_177952_p() - radius >> 4; z <= pos.func_177952_p() + radius >> 4; ++z) {
                Chunk chunk = HeatEnchantEffect.getLoadedChunk(world, x, z);
                if (chunk == null) continue;
                for (BlockPos tilePos : chunk.func_203066_o()) {
                    if (!(tilePos.func_177951_i((Vector3i)pos) <= (double)(radius * radius))) continue;
                    list.add(world.func_175625_s(tilePos));
                }
            }
        }
        return list;
    }

    private static Chunk getLoadedChunk(IWorld world, int x, int z) {
        AbstractChunkProvider provider = world.func_72863_F();
        if (provider.func_222865_a(new ChunkPos(x, z))) {
            return provider.func_217205_a(x, z, false);
        }
        return null;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

