/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.LogicalSide;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.util.ModRef;

public class LoyaltyEnchantEffect
extends AbstractEnchantEffect {
    public static final ResourceLocation NAME = ModRef.createRes("loyalty");
    private final Set<PetReviver> revivers = new HashSet<PetReviver>();

    public LoyaltyEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    public static void petDied(LoyaltyEnchantEffect effect, LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof TameableEntity && ((TameableEntity)event.getEntityLiving()).func_152114_e((LivingEntity)effect.player)) {
            if (!effect.player.field_70170_p.field_72995_K) {
                int level = Math.min(effect.level(), Enchantments.field_203193_C.func_77325_b());
                effect.revivers.add(new PetReviver(effect.player.field_70170_p.func_82737_E() + (long)((Integer)((List)ModConfig.get().loyaltyReviveTimes.get()).get(level - 1)).intValue(), (TameableEntity)event.getEntityLiving()));
                event.getEntityLiving().remove(true);
            }
            event.setCanceled(true);
        }
    }

    public static void revivePet(LoyaltyEnchantEffect effect, TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Iterator<PetReviver> iterator = effect.revivers.iterator();
            while (iterator.hasNext()) {
                PetReviver reviver = iterator.next();
                if (!reviver.canRevive(effect.player.field_70170_p)) continue;
                reviver.revivePet();
                iterator.remove();
            }
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    private static class PetReviver {
        public long reviveTime;
        public final TameableEntity pet;

        public PetReviver(long reviveTime, TameableEntity pet) {
            this.reviveTime = reviveTime;
            this.pet = pet;
        }

        public boolean canRevive(World world) {
            return world.func_82737_E() >= this.reviveTime;
        }

        public void revivePet() {
            BlockPos pos;
            ServerWorld spawnWorld = this.pet.func_184102_h().func_241755_D_();
            Vector3d spawn = Vector3d.func_237492_c_((Vector3i)spawnWorld.func_241135_u_());
            ServerPlayerEntity player = this.pet.func_184102_h().func_184103_al().func_177451_a(this.pet.func_184753_b());
            if (player != null && (pos = player.func_241140_K_()) != null) {
                Optional respawn;
                float f = player.func_242109_L();
                ServerWorld respawnWorld = player.func_184102_h().func_71218_a(player.func_241141_L_());
                if (respawnWorld != null && (respawn = PlayerEntity.func_242374_a((ServerWorld)respawnWorld, (BlockPos)pos, (float)f, (boolean)false, (boolean)true)).isPresent()) {
                    spawnWorld = respawnWorld;
                    spawn = (Vector3d)respawn.get();
                }
            }
            TameableEntity spawnedPet = this.pet;
            if (this.pet.field_70170_p != spawnWorld) {
                ((ServerWorld)this.pet.field_70170_p).removeEntity((Entity)this.pet, true);
                spawnedPet = (TameableEntity)this.pet.func_200600_R().func_200721_a((World)spawnWorld);
            }
            spawnedPet.func_180432_n((Entity)this.pet);
            spawnedPet.func_213293_j(0.0, 0.0, 0.0);
            spawnedPet.func_70012_b(spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c, this.pet.field_70177_z, this.pet.field_70125_A);
            while (!spawnWorld.func_226669_j_((Entity)spawnedPet)) {
                spawnedPet.func_70107_b(spawnedPet.func_226277_ct_(), spawnedPet.func_226278_cu_() + 1.0, spawnedPet.func_226281_cx_());
            }
            spawnedPet.func_70606_j(spawnedPet.func_110138_aP());
            spawnedPet.func_70661_as().func_75499_g();
            spawnedPet.func_233687_w_(true);
            spawnedPet.func_70637_d(false);
            spawnedPet.func_70624_b(null);
            if (this.pet.field_70170_p != spawnWorld) {
                this.pet.remove(false);
            } else {
                spawnedPet.revive();
            }
            spawnWorld.func_217376_c((Entity)spawnedPet);
        }
    }
}

