/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.common.util.ModRef;

public class LureEnchantEffect
extends AbstractEnchantEffect {
    public static final float SPAWN_ANGLE = 120.0f;
    public static final float MIN_DISTANCE = 15.0f;
    public static final float MAX_DISTANCE = 50.0f;
    public static final float CHANCE = 0.05f;
    public static final int TEST_INTERVAL = 200;
    public static final ResourceLocation NAME = ModRef.createRes("lure");

    public LureEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    public static void spawnAnimals(LureEnchantEffect effect, TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            ServerWorld world = (ServerWorld)event.player.field_70170_p;
            if (world.func_82737_E() % 200L == 0L && world.func_201674_k().nextFloat() < 0.05f) {
                Biome biome = world.func_226691_t_(player.func_233580_cy_());
                MobSpawnInfo spawnInfo = biome.func_242433_b();
                ArrayList spawners = new ArrayList();
                spawners.addAll(spawnInfo.func_242559_a(EntityClassification.CREATURE));
                spawners.addAll(spawnInfo.func_242559_a(EntityClassification.WATER_CREATURE));
                List animalTypes = spawners.stream().map(entry -> entry.field_242588_c).collect(Collectors.toList());
                if (animalTypes.isEmpty()) {
                    return;
                }
                EntityType type = (EntityType)animalTypes.get(world.func_201674_k().nextInt(animalTypes.size()));
                Entity animal = type.func_200721_a((World)world);
                if (animal != null) {
                    for (int test = 0; test < 50; ++test) {
                        float angle = MathHelper.func_151240_a((Random)world.func_201674_k(), (float)(player.field_70759_as + 180.0f - 60.0f), (float)(player.field_70759_as + 180.0f + 60.0f));
                        float distance = MathHelper.func_151240_a((Random)world.func_201674_k(), (float)15.0f, (float)50.0f);
                        BlockPos spawnPos = new BlockPos(Vector3d.func_189986_a((float)0.0f, (float)angle).func_186678_a((double)distance)).func_177971_a((Vector3i)player.func_233580_cy_());
                        int spawnHeight = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, spawnPos.func_177958_n(), spawnPos.func_177952_p());
                        if (type.func_220339_d() == EntityClassification.WATER_CREATURE) {
                            spawnHeight = LureEnchantEffect.getRandomHeight(spawnHeight, world.func_201676_a(Heightmap.Type.OCEAN_FLOOR, spawnPos.func_177958_n(), spawnPos.func_177952_p()), world.func_201674_k());
                        }
                        if (!world.isAreaLoaded(spawnPos = new BlockPos(spawnPos.func_177958_n(), spawnHeight, spawnPos.func_177952_p()), 1) || !EntitySpawnPlacementRegistry.func_223515_a((EntityType)type, (IServerWorld)world, (SpawnReason)SpawnReason.NATURAL, (BlockPos)spawnPos, (Random)world.func_201674_k())) continue;
                        animal.func_70080_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), 360.0f * (float)Math.random(), 0.0f);
                        if (!world.func_226669_j_(animal)) continue;
                        world.func_217376_c(animal);
                        break;
                    }
                }
            }
        }
    }

    private static int getRandomHeight(int firstY, int secondY, Random random) {
        int min = Math.min(firstY, secondY);
        int max = Math.max(firstY, secondY);
        return min + random.nextInt(max - min);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

