/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants.impl;

import java.lang.reflect.Field;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import quarris.enchantability.api.enchants.AbstractEnchantEffect;
import quarris.enchantability.mod.common.util.ModRef;

public class SwiftChargeEnchantEffect
extends AbstractEnchantEffect {
    public static final ResourceLocation NAME = ModRef.createRes("swift_charge");
    private static final Field PORTAL_COUNTER = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_82153_h");
    private static final Field SLEEP_TIMER = ObfuscationReflectionHelper.findField(PlayerEntity.class, (String)"field_71076_b");

    public SwiftChargeEnchantEffect(PlayerEntity player, Enchantment enchantment, int level) {
        super(player, enchantment, level);
    }

    @Override
    public void onApplied() {
        this.player.func_110148_a(Attributes.field_233825_h_).func_233767_b_(new AttributeModifier(ModRef.ENCHANT_UUID, () -> ((ResourceLocation)NAME).toString(), (double)((float)this.level() / 2.0f), AttributeModifier.Operation.ADDITION));
    }

    @Override
    public void onRemoved() {
        this.player.func_110148_a(Attributes.field_233825_h_).func_188479_b(ModRef.ENCHANT_UUID);
    }

    public static void itemUse(SwiftChargeEnchantEffect effect, LivingEntityUseItemEvent.Start event) {
        ItemStack item = event.getItem();
        if (item.func_222117_E() || item.func_77973_b() instanceof PotionItem) {
            event.setDuration(event.getDuration() / (effect.level() + 1));
        }
    }

    public static void transition(SwiftChargeEnchantEffect effect, TickEvent.PlayerTickEvent event) {
        PlayerEntity player = effect.player;
        boolean inPortal = (Boolean)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)player, (String)"field_71087_bX");
        if (inPortal) {
            try {
                int portalTicks = PORTAL_COUNTER.getInt(player);
                PORTAL_COUNTER.setInt(player, portalTicks + effect.level());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (player.func_70608_bn()) {
            try {
                int sleepTicks = SLEEP_TIMER.getInt(player);
                SLEEP_TIMER.setInt(player, sleepTicks + effect.level());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (this.player.func_110148_a(Attributes.field_233825_h_).func_111127_a(ModRef.ENCHANT_UUID) == null) {
            this.onApplied();
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

