/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.events;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.capabilities.IPlayerEnchant;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.capabilities.PlayerEnchant;
import quarris.enchantability.mod.common.content.WitherHeartItem;
import quarris.enchantability.mod.common.network.EnderChestInteractPacket;
import quarris.enchantability.mod.common.network.PacketHandler;
import quarris.enchantability.mod.common.network.SyncClientPacket;
import quarris.enchantability.mod.common.util.ModRef;

@Mod.EventBusSubscriber(modid="enchantability")
public class CommonEvents {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        LiteralCommandNode root = event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ench").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"extended").executes(source -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)source, (String)"player");
            player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(player.func_145748_c_() + " has extended slots: " + cap.isExtended()), false));
            return 1;
        })).then(Commands.func_197056_a((String)"extended", (ArgumentType)BoolArgumentType.bool()).executes(source -> {
            boolean set = BoolArgumentType.getBool((CommandContext)source, (String)"extended");
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)source, (String)"player");
            player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> cap.setExtended(set));
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Set extended enchant inventory for " + player.func_145748_c_() + " to " + set), false);
            return 1;
        })))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"enchantability").requires(source -> source.func_197034_c(2))).redirect((CommandNode)root));
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(ModRef.createRes("enchant"), (ICapabilityProvider)new PlayerEnchant((PlayerEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void enderChestContainerInteraction(PlayerContainerEvent event) {
        ChestContainer cont;
        if (event.getContainer() instanceof ChestContainer && (cont = (ChestContainer)event.getContainer()).func_85151_d() instanceof EnderChestInventory) {
            PacketHandler.INSTANCE.sendTo((Object)new EnderChestInteractPacket(event.getClass().equals(PlayerContainerEvent.Open.class)), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void reloadTags(TagsUpdatedEvent event) {
        ModConfig.get().reloadTags();
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> {
                if (cap.isDirty()) {
                    cap.updateEffects();
                    cap.markDirty(false);
                    PacketHandler.INSTANCE.sendTo((Object)new SyncClientPacket((CompoundNBT)cap.serializeNBT()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> PacketHandler.INSTANCE.sendTo((Object)new SyncClientPacket((CompoundNBT)cap.serializeNBT()), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT));
    }

    @SubscribeEvent
    public static void cloneCapabilities(PlayerEvent.Clone e) {
        try {
            IPlayerEnchant original = (IPlayerEnchant)e.getOriginal().getCapability(EnchantabilityApi.playerEnchant).orElse(null);
            CompoundNBT nbt = (CompoundNBT)original.serializeNBT();
            IPlayerEnchant clone = (IPlayerEnchant)e.getPlayer().getCapability(EnchantabilityApi.playerEnchant).orElse(null);
            clone.deserializeNBT((INBT)nbt);
            clone.markDirty(true);
        }
        catch (Exception exp) {
            ModRef.LOGGER.warn("Failed to clone player " + e.getOriginal().func_200200_C_(), (Throwable)exp);
        }
    }

    @SubscribeEvent
    public static void spawnWitherHeart(LivingDeathEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (world.func_201670_d()) {
            return;
        }
        if (event.getEntityLiving().func_200600_R() == EntityType.field_200760_az) {
            WitherEntity wither = (WitherEntity)event.getEntityLiving();
            List combatants = (List)ObfuscationReflectionHelper.getPrivateValue(CombatTracker.class, (Object)wither.func_110142_aN(), (String)"field_94556_a");
            if (combatants == null) {
                return;
            }
            HashSet<Pair> fighters = new HashSet<Pair>();
            for (CombatEntry entry : combatants) {
                PlayerEntity player;
                if (!entry.func_94559_f() || !(entry.func_94560_a().func_76346_g() instanceof PlayerEntity) || ((IPlayerEnchant)(player = (PlayerEntity)entry.func_94560_a().func_76346_g()).getCapability(EnchantabilityApi.playerEnchant).orElse(null)).isExtended()) continue;
                fighters.add(Pair.of((Object)player.func_110124_au(), (Object)player.func_145748_c_().getString()));
            }
            for (Pair fighter : fighters) {
                ItemStack witherHeart = new ItemStack((IItemProvider)WitherHeartItem.WITHER_HEART);
                witherHeart.func_196082_o().func_186854_a("Owner", (UUID)fighter.getLeft());
                witherHeart.func_77978_p().func_74778_a("OwnerName", (String)fighter.getRight());
                ItemEntity entity = new ItemEntity(world, wither.func_226282_d_(1.0), wither.func_226279_cv_(), wither.func_226287_g_(1.0), witherHeart);
                world.func_217376_c((Entity)entity);
            }
        }
    }

    @SubscribeEvent
    public static void blockWitherHeartPickup(EntityItemPickupEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack item = event.getItem().func_92059_d();
        if (item.func_77973_b() != WitherHeartItem.WITHER_HEART) {
            return;
        }
        if (item.func_77978_p() == null || event.getPlayer().func_110124_au().equals(item.func_77978_p().func_186857_a("Owner"))) {
            return;
        }
        event.setCanceled(true);
    }
}

