/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.enchantedbookredesign;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod(value="enchantedbookredesign")
public class EnchantedBookRedesign {
    public static final String MODID = "enchantedbookredesign";
    private static ResourcePack internalResourcePack;

    public EnchantedBookRedesign() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            List modFiles = ModList.get().getModFiles();
            for (ModFileInfo modFileInfo : modFiles) {
                if (!((IModInfo)modFileInfo.getMods().get(0)).getModId().equals(MODID)) continue;
                internalResourcePack = new ModFileResourcePack(modFileInfo.getFile());
                break;
            }
            ResourcePackList rps = Minecraft.func_71410_x().func_195548_H();
            rps.func_198982_a(new IPackFinder(){

                public <T extends ResourcePackInfo> void func_195730_a(@Nonnull Map<String, T> nameToPackMap, @Nonnull ResourcePackInfo.IFactory<T> packInfoFactory) {
                    ClientResourcePackInfo pack = new ClientResourcePackInfo(EnchantedBookRedesign.MODID, true, () -> internalResourcePack, (ITextComponent)new StringTextComponent(internalResourcePack.func_195762_a()), (ITextComponent)new StringTextComponent(internalResourcePack.func_195762_a()), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.TOP, true, null, true);
                    nameToPackMap.put(EnchantedBookRedesign.MODID, pack);
                }
            });
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        Items.field_151134_bR.func_185043_a(new ResourceLocation(MODID, "level"), (stack, world, entity) -> {
            Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
            if (enchs.isEmpty()) {
                return 1.0f;
            }
            int level = 1;
            for (Map.Entry entry : enchs.entrySet()) {
                if (((Enchantment)entry.getKey()).func_190936_d()) {
                    return 0.0f;
                }
                level = Math.max(level, (Integer)entry.getValue());
            }
            return level;
        });
        Minecraft mc = Minecraft.func_71410_x();
        ItemColors itemColors = mc.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> tintIndex != 1 ? -1 : EnchantedBookRedesign.getColor(stack), new IItemProvider[]{Items.field_151134_bR});
    }

    public static int getColor(ItemStack stack) {
        Map enchs = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchs.isEmpty()) {
            return 0xFFFFFF;
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double buckets = 0.0;
        int potency = 0;
        int potentialPotency = 0;
        for (Map.Entry entry : enchs.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            int power = (Integer)entry.getValue() + 1;
            int maxPower = ench.func_77325_b() + 1;
            potency += power;
            potentialPotency += maxPower;
            int color = 0;
            if (!ench.func_190936_d()) {
                if (ench.field_77351_y == null) {
                    color = 7033882;
                } else {
                    switch (ench.field_77351_y) {
                        case ARMOR: 
                        case ARMOR_FEET: 
                        case ARMOR_LEGS: 
                        case ARMOR_CHEST: 
                        case ARMOR_HEAD: 
                        case WEARABLE: {
                            color = 65280;
                            break;
                        }
                        case WEAPON: {
                            color = 0xFF0000;
                            break;
                        }
                        case DIGGER: {
                            color = 7819047;
                            break;
                        }
                        case FISHING_ROD: {
                            color = 255;
                            break;
                        }
                        case TRIDENT: {
                            color = 0x9F7FFF;
                            break;
                        }
                        case BOW: {
                            color = 16743168;
                            break;
                        }
                        case CROSSBOW: {
                            color = 65535;
                            break;
                        }
                        default: {
                            color = 7033882;
                        }
                    }
                }
            }
            int cr = (color & 0xFF0000) >> 16;
            int cg = (color & 0xFF00) >> 8;
            int cb = color & 0xFF;
            double levelMul = (double)power / (double)maxPower;
            r += (double)cr * levelMul;
            g += (double)cg * levelMul;
            b += (double)cb * levelMul;
            buckets += levelMul;
        }
        double multiplier = (1.0 + (double)potency / (double)potentialPotency) / (2.0 * buckets);
        int trueR = (int)(r * multiplier);
        int trueG = (int)(g * multiplier);
        int trueB = (int)(b * multiplier);
        return 0xFF000000 | trueR << 16 | trueG << 8 | trueB;
    }
}

