/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.blocks;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.blocks.TileEnderRift;
import gigaherz.enderRift.client.SBRHEnderRift;
import gigaherz.enderRift.storage.RiftStorageWorldData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderRift
extends Block
implements ITileEntityProvider {
    public IIcon iconMain;
    public IIcon iconBase;
    public boolean isInventory;
    public final BlockEnderRift asInventory;

    public BlockEnderRift(boolean isInventory) {
        super(Material.field_151576_e);
        this.isInventory = isInventory;
        this.func_149658_d("enderRift".toLowerCase() + ":block_casing");
        this.asInventory = null;
    }

    public BlockEnderRift() {
        super(Material.field_151576_e);
        this.func_149647_a(EnderRiftMod.tabEnderRift);
        this.func_149658_d("enderRift".toLowerCase() + ":block_casing");
        this.asInventory = new BlockEnderRift(true);
    }

    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        if (!this.isInventory) {
            this.iconMain = register.func_94245_a("enderRift".toLowerCase() + ":block_rift");
            this.iconBase = register.func_94245_a("enderRift".toLowerCase() + ":block_rift_base");
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return this.isInventory ? super.func_149645_b() : SBRHEnderRift.renderId;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) != 0 ? 15 : 0;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) != 0 ? 1 : 15;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEnderRift();
    }

    public boolean tryCompleteStructure(World world, int x, int y, int z, ItemStack itemStack) {
        if (world.func_147439_a(x, y, z) != EnderRiftMod.blockEnderRift) {
            return false;
        }
        if (world.func_72805_g(x, y, z) != 0) {
            return false;
        }
        if (world.func_147439_a(x - 1, y, z).isNormalCube((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (world.func_147439_a(x + 1, y, z).isNormalCube((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z).isNormalCube((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (world.func_147439_a(x, y, z - 1).isNormalCube((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (world.func_147439_a(x, y, z + 1).isNormalCube((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (world.func_147439_a(x - 1, y, z - 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y, z - 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x - 1, y, z + 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y, z + 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x - 1, y - 1, z - 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x, y - 1, z - 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y - 1, z - 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x - 1, y - 1, z) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x, y - 1, z) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y - 1, z) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x - 1, y - 1, z + 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x, y - 1, z + 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y - 1, z + 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x - 1, y + 1, z - 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z - 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y + 1, z - 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x - 1, y + 1, z) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y + 1, z) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x - 1, y + 1, z + 1) != Blocks.field_150339_S) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z + 1) != Blocks.field_150451_bX) {
            return false;
        }
        if (world.func_147439_a(x + 1, y + 1, z + 1) != Blocks.field_150339_S) {
            return false;
        }
        world.func_147465_d(x - 1, y - 1, z - 1, EnderRiftMod.blockStructureCorner, 0, 3);
        world.func_147465_d(x + 1, y - 1, z - 1, EnderRiftMod.blockStructureCorner, 1, 3);
        world.func_147465_d(x - 1, y + 1, z - 1, EnderRiftMod.blockStructureCorner, 2, 3);
        world.func_147465_d(x + 1, y + 1, z - 1, EnderRiftMod.blockStructureCorner, 3, 3);
        world.func_147465_d(x - 1, y - 1, z + 1, EnderRiftMod.blockStructureCorner, 4, 3);
        world.func_147465_d(x + 1, y - 1, z + 1, EnderRiftMod.blockStructureCorner, 5, 3);
        world.func_147465_d(x - 1, y + 1, z + 1, EnderRiftMod.blockStructureCorner, 6, 3);
        world.func_147465_d(x + 1, y + 1, z + 1, EnderRiftMod.blockStructureCorner, 7, 3);
        world.func_147465_d(x, y - 1, z, EnderRiftMod.blockStructureInvisible, 0, 3);
        world.func_147465_d(x, y - 1, z - 1, EnderRiftMod.blockStructureInvisible, 4, 3);
        world.func_147465_d(x, y + 1, z - 1, EnderRiftMod.blockStructureInvisible, 5, 3);
        world.func_147465_d(x, y - 1, z + 1, EnderRiftMod.blockStructureInvisible, 6, 3);
        world.func_147465_d(x, y + 1, z + 1, EnderRiftMod.blockStructureInvisible, 7, 3);
        world.func_147465_d(x - 1, y, z - 1, EnderRiftMod.blockStructureInvisible, 8, 3);
        world.func_147465_d(x + 1, y, z - 1, EnderRiftMod.blockStructureInvisible, 9, 3);
        world.func_147465_d(x - 1, y, z + 1, EnderRiftMod.blockStructureInvisible, 10, 3);
        world.func_147465_d(x + 1, y, z + 1, EnderRiftMod.blockStructureInvisible, 11, 3);
        world.func_147465_d(x - 1, y - 1, z, EnderRiftMod.blockStructureInvisible, 12, 3);
        world.func_147465_d(x + 1, y - 1, z, EnderRiftMod.blockStructureInvisible, 13, 3);
        world.func_147465_d(x - 1, y + 1, z, EnderRiftMod.blockStructureInvisible, 14, 3);
        world.func_147465_d(x + 1, y + 1, z, EnderRiftMod.blockStructureInvisible, 15, 3);
        world.func_72921_c(x, y, z, 1, 3);
        TileEnderRift rift = (TileEnderRift)world.func_147438_o(x, y, z);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("RiftId")) {
            rift.inventory = null;
            rift.field_145847_g = -1;
            rift.riftId = tagCompound.func_74762_e("RiftId");
        } else {
            rift.inventory = null;
            rift.field_145847_g = -1;
            rift.riftId = RiftStorageWorldData.get(world).getNextRiftId();
        }
        return true;
    }

    public void breakStructure(World world, int x, int y, int z) {
        this.restoreStructureBlockTo(world, x, y - 1, z, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x - 1, y, z - 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y, z - 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x - 1, y, z + 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y, z + 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x - 1, y - 1, z - 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x, y - 1, z - 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y - 1, z - 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x - 1, y - 1, z, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y - 1, z, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x - 1, y - 1, z + 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x, y - 1, z + 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y - 1, z + 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x - 1, y + 1, z - 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x, y + 1, z - 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y + 1, z - 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x - 1, y + 1, z, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y + 1, z, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x - 1, y + 1, z + 1, Blocks.field_150339_S);
        this.restoreStructureBlockTo(world, x, y + 1, z + 1, Blocks.field_150451_bX);
        this.restoreStructureBlockTo(world, x + 1, y + 1, z + 1, Blocks.field_150339_S);
        if (world.func_147439_a(x, y, z) == EnderRiftMod.blockEnderRift && world.func_72805_g(x, y, z) != 0) {
            world.func_72921_c(x, y, z, 0, 3);
            TileEnderRift rift = (TileEnderRift)world.func_147438_o(x, y, z);
            rift.inventory = null;
            rift.field_145847_g = -1;
            ItemStack stack = rift.getRiftItem();
            EntityItem entity = new EntityItem(world, (double)x, (double)y, (double)z, stack);
            world.func_72838_d((Entity)entity);
        }
    }

    private void restoreStructureBlockTo(World world, int xx, int yy, int zz, Block bb) {
        if (world.func_147439_a(xx, yy, zz) == EnderRiftMod.blockStructureInvisible || world.func_147439_a(xx, yy, zz) == EnderRiftMod.blockStructureCorner) {
            world.func_147449_b(xx, yy, zz, bb);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
        this.breakStructure(world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Item.func_150898_a((Block)this), 1, 0));
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEnderRift) {
            ret.add(((TileEnderRift)te).getRiftItem());
        }
        return ret;
    }

    public boolean tryDuplicateRift(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEnderRift)) {
            return false;
        }
        ItemStack stack = ((TileEnderRift)te).getRiftItem();
        EntityItem entity = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
        world.func_72838_d((Entity)entity);
        return true;
    }
}

