/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.blocks;

import cofh.api.energy.IEnergyReceiver;
import gigaherz.enderRift.ConfigValues;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.storage.RiftInventory;
import gigaherz.enderRift.storage.RiftStorageWorldData;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnderRift
extends TileEntity
implements IEnergyReceiver,
IInventory {
    public static int BroadcastRange = 256;
    public final int energyLimit = 10000000;
    public int energyBuffer = 0;
    public int riftId;
    RiftInventory inventory;
    boolean alreadyMarkedDirty;

    RiftInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = RiftStorageWorldData.get(this.field_145850_b).getRift(this.riftId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getEnergyInsert() {
        int sizeInventory = this.getInventory().func_70302_i_();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return (int)Math.ceil(ConfigValues.PowerPerInsertionConstant + (float)sizeInventory * ConfigValues.PowerPerInsertionLinear + (float)sizeInventory2 * ConfigValues.PowerPerInsertionGeometric);
    }

    public int getEnergyExtract() {
        int sizeInventory = this.getInventory().func_70302_i_();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return (int)Math.ceil(ConfigValues.PowerPerExtractionConstant + (float)sizeInventory * ConfigValues.PowerPerExtractionLinear + (float)sizeInventory2 * ConfigValues.PowerPerExtractionGeometric);
    }

    public int countInventoryStacks() {
        return this.getInventory().countInventoryStacks();
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.getInventory().func_70301_a(slotIndex);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null) {
            ItemStack oldStack = this.func_70301_a(slot);
            if (oldStack == null) {
                return;
            }
            int powerCost = this.getEnergyExtract();
            if (this.energyBuffer >= powerCost) {
                this.getInventory().func_70299_a(slot, null);
                this.energyBuffer -= powerCost;
            }
            return;
        }
        int powerCost = this.getEnergyInsert();
        if (this.energyBuffer >= powerCost) {
            this.getInventory().func_70299_a(slot, stack);
            this.energyBuffer -= powerCost;
        } else {
            stack.field_77994_a = 0;
        }
        if (stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.getInventory().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInventory().func_145818_k_();
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return null;
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getInventory().func_70296_d();
    }

    public void setDirty() {
        if (this.alreadyMarkedDirty) {
            return;
        }
        this.alreadyMarkedDirty = true;
        super.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.energyBuffer >= this.getEnergyInsert();
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.energyBuffer = nbtTagCompound.func_74762_e("Energy");
        this.riftId = nbtTagCompound.func_74762_e("RiftId");
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Energy", this.energyBuffer);
        nbtTagCompound.func_74768_a("RiftId", this.riftId);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int receive = Math.min(maxReceive, 10000000 - this.energyBuffer);
        if (!simulate && receive > 0) {
            this.energyBuffer += receive;
            this.setDirty();
        }
        return receive;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyBuffer;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 10000000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    public void updateValue(int barIndex, int barValue) {
        if (barIndex == 0) {
            this.energyBuffer = barValue;
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock || oldMeta != 0 != (newMeta != 0);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.alreadyMarkedDirty = false;
    }

    public boolean canUpdate() {
        return true;
    }

    public ItemStack getRiftItem() {
        ItemStack stack = new ItemStack(EnderRiftMod.itemEnderRift);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("RiftId", this.riftId);
        stack.func_77982_d(tag);
        return stack;
    }
}

