/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import gigaherz.enderRift.blocks.TileEnderRift;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ValueUpdate
implements IMessage {
    int dim;
    int posX;
    int posY;
    int posZ;
    public int barIndex;
    public int barValue;

    public ValueUpdate() {
    }

    public ValueUpdate(TileEntity tile, int bar, int value) {
        this.dim = tile.func_145831_w().field_73011_w.field_76574_g;
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.barIndex = bar;
        this.barValue = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.barIndex = buf.readInt();
        this.barValue = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.barIndex);
        buf.writeInt(this.barValue);
    }

    public TileEntity getTileEntityTarget() {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        return world.func_147438_o(this.posX, this.posY, this.posZ);
    }

    public static class Handler
    implements IMessageHandler<ValueUpdate, IMessage> {
        public IMessage onMessage(ValueUpdate message, MessageContext ctx) {
            TileEntity tile = message.getTileEntityTarget();
            if (!(tile instanceof TileEnderRift)) {
                return null;
            }
            TileEnderRift rift = (TileEnderRift)tile;
            rift.updateValue(message.barIndex, message.barValue);
            return null;
        }
    }
}

