/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.storage;

import gigaherz.enderRift.blocks.TileEnderRift;
import gigaherz.enderRift.storage.RiftStorageWorldData;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RiftInventory
implements IInventory {
    private final List<ItemStack> inventorySlots = new ArrayList<ItemStack>();
    private final RiftStorageWorldData manager;
    final List<Reference<? extends TileEnderRift>> listeners = new ArrayList<Reference<? extends TileEnderRift>>();
    final ReferenceQueue<TileEnderRift> deadListeners = new ReferenceQueue();

    RiftInventory(RiftStorageWorldData manager) {
        this.manager = manager;
    }

    public void addWeakListener(TileEnderRift e) {
        this.listeners.add(new WeakReference<TileEnderRift>(e, this.deadListeners));
    }

    public void func_70296_d() {
        Reference<TileEnderRift> ref = this.deadListeners.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.deadListeners.poll();
        }
        Iterator<Reference<? extends TileEnderRift>> it = this.listeners.iterator();
        while (it.hasNext()) {
            TileEnderRift rift = it.next().get();
            if (rift == null || rift.func_145837_r()) {
                it.remove();
                continue;
            }
            rift.setDirty();
        }
        this.manager.func_76185_a();
    }

    public int countInventoryStacks() {
        int count = 0;
        for (ItemStack stack : this.inventorySlots) {
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    public int func_70302_i_() {
        return this.inventorySlots.size() + 1;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (slotIndex >= this.inventorySlots.size()) {
            return null;
        }
        return this.inventorySlots.get(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack stack) {
        if (stack == null) {
            if (slotIndex >= this.inventorySlots.size()) {
                return;
            }
            this.inventorySlots.remove(slotIndex);
            this.func_70296_d();
            return;
        }
        if (slotIndex >= this.inventorySlots.size()) {
            this.inventorySlots.add(stack);
            this.func_70296_d();
            return;
        }
        this.inventorySlots.set(slotIndex, stack);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack stack = this.func_70301_a(slotIndex);
        if (stack == null) {
            return null;
        }
        if (stack.field_77994_a <= amount) {
            this.func_70299_a(slotIndex, null);
        } else {
            stack = stack.func_77979_a(amount);
            if (stack.field_77994_a == 0) {
                this.func_70299_a(slotIndex, null);
            }
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventorySlots.clear();
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound1 = nbtTagList.func_150305_b(i);
            int j = nbtTagCompound1.func_74762_e("Slot");
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound1));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
            nbtTagCompound1.func_74768_a("Slot", i);
            stack.func_77955_b(nbtTagCompound1);
            nbtTagList.func_74742_a((NBTBase)nbtTagCompound1);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)nbtTagList);
    }
}

