/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import gigaherz.common.BlockRegistered;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.TileAggregator;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockAggregator<T extends TileAggregator>
extends BlockRegistered {
    public BlockAggregator(String name, Material blockMaterialIn, MapColor blockMapColorIn) {
        super(name, blockMaterialIn, blockMapColorIn);
    }

    public BlockAggregator(String name, Material materialIn) {
        super(name, materialIn);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract T createTileEntity(World var1, IBlockState var2);

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block otherBlock, BlockPos otherPos) {
        super.func_189540_a(state, worldIn, pos, otherBlock, otherPos);
        TileEntity teSelf = worldIn.func_175625_s(pos);
        if (!(teSelf instanceof TileAggregator)) {
            return;
        }
        ((TileAggregator)teSelf).updateNeighbours();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        this.recheckNeighbour(world, pos, neighbor);
    }

    protected void recheckNeighbour(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        EnumFacing side = null;
        if (neighbor.equals((Object)pos.func_177974_f())) {
            side = EnumFacing.EAST;
        }
        if (neighbor.equals((Object)pos.func_177976_e())) {
            side = EnumFacing.WEST;
        }
        if (neighbor.equals((Object)pos.func_177978_c())) {
            side = EnumFacing.NORTH;
        }
        if (neighbor.equals((Object)pos.func_177968_d())) {
            side = EnumFacing.SOUTH;
        }
        if (neighbor.equals((Object)pos.func_177984_a())) {
            side = EnumFacing.UP;
        }
        if (neighbor.equals((Object)pos.func_177977_b())) {
            side = EnumFacing.DOWN;
        }
        if (side != null && this.isAutomatable(world, pos, side)) {
            TileEntity teSelf = world.func_175625_s(pos);
            if (!(teSelf instanceof TileAggregator)) {
                return;
            }
            ((TileAggregator)teSelf).updateConnectedInventories();
        }
    }

    protected boolean isAutomatable(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        if (te == null) {
            return false;
        }
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }

    protected boolean isConnectableAutomation(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        if (te == null) {
            return false;
        }
        if (te instanceof TileAggregator) {
            return true;
        }
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }
}

