/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventoryAggregator
implements IItemHandler {
    final List<IItemHandler> aggregated = Lists.newArrayList();

    public void addAll(Iterable<IItemHandler> inventorySet) {
        for (IItemHandler value : inventorySet) {
            this.add(value);
        }
    }

    public void add(IItemHandler inv) {
        this.aggregated.add(inv);
    }

    public int getSlots() {
        int sum = 0;
        for (IItemHandler inv : this.aggregated) {
            sum += inv.getSlots();
        }
        return sum;
    }

    public ItemStack getStackInSlot(int index) {
        for (IItemHandler inv : this.aggregated) {
            int size = inv.getSlots();
            if (index < size) {
                return inv.getStackInSlot(index);
            }
            index -= size;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int index, ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.aggregated.size(); ++i) {
            IItemHandler inv = this.aggregated.get(i);
            int size = inv.getSlots();
            if (index < size) {
                return inv.insertItem(index, stack, simulate);
            }
            index -= size;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int index, int amount, boolean simulate) {
        for (int i = 0; i < this.aggregated.size(); ++i) {
            IItemHandler inv = this.aggregated.get(i);
            int size = inv.getSlots();
            if (index < size) {
                return inv.extractItem(index, amount, simulate);
            }
            index -= size;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int index) {
        for (IItemHandler inv : this.aggregated) {
            int size = inv.getSlots();
            if (index < size) {
                return inv.getSlotLimit(index);
            }
            index -= size;
        }
        return 0;
    }
}

