/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.EnergyAggregator;
import gigaherz.enderRift.automation.InventoryAggregator;
import gigaherz.enderRift.common.AutomationEnergyWrapper;
import gigaherz.enderRift.common.IPoweredAutomation;
import gigaherz.graph.api.Graph;
import gigaherz.graph.api.GraphObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileAggregator
extends TileEntity
implements ITickable,
GraphObject,
IPoweredAutomation {
    private Graph graph;
    private boolean firstUpdate = true;
    private final List<IItemHandler> connectedInventories = Lists.newArrayList();
    private AutomationEnergyWrapper wrapper = new AutomationEnergyWrapper(this);
    private int temporaryLowOnPowerTicks = 0;

    @Nullable
    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.firstUpdate) {
            this.init();
        }
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.init();
        }
        if (this.temporaryLowOnPowerTicks > 0) {
            --this.temporaryLowOnPowerTicks;
        }
    }

    private void init() {
        Graph.integrate((GraphObject)this, this.getNeighbours());
        this.updateConnectedInventories();
    }

    public void func_145843_s() {
        super.func_145843_s();
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.remove((GraphObject)this);
        }
    }

    void updateNeighbours() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.addNeighours((GraphObject)this, this.getNeighbours());
        }
        this.updateConnectedInventories();
    }

    private List<GraphObject> getNeighbours() {
        ArrayList neighbours = Lists.newArrayList();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileAggregator thingOther;
            TileEntity teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            if (!(teOther instanceof TileAggregator) || (thingOther = (TileAggregator)teOther).getGraph() == null) continue;
            neighbours.add(thingOther);
        }
        return neighbours;
    }

    public void lazyNotifyDirty() {
        if (this.getGraph() == null) {
            return;
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            TileAggregator other;
            if (!(object instanceof TileAggregator) || (other = (TileAggregator)object).func_145837_r()) continue;
            other.lazyDirty();
        }
    }

    @Override
    @Nullable
    public IItemHandler getInventory() {
        return this.getCombinedInventoryInternal();
    }

    @Override
    public IEnergyStorage getEnergyBuffer() {
        return this.getCombinedPowerBuffer();
    }

    protected abstract void lazyDirty();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    protected void updateConnectedInventories() {
        this.connectedInventories.clear();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntity teOther;
            if (!this.canConnectSide(f) || (teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f))) == null || teOther instanceof TileAggregator || !AutomationHelper.isAutomatable(teOther, f.func_176734_d()) || !teOther.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d())) continue;
            this.connectedInventories.add((IItemHandler)teOther.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()));
        }
        this.lazyNotifyDirty();
    }

    protected abstract boolean canConnectSide(EnumFacing var1);

    public IItemHandler getCombinedInventory() {
        return this.wrapper;
    }

    @Nullable
    public IEnergyStorage getInternalBuffer() {
        return null;
    }

    private IItemHandler getCombinedInventoryInternal() {
        InventoryAggregator aggregator = new InventoryAggregator();
        if (this.getGraph() == null) {
            return aggregator;
        }
        HashSet inventories = Sets.newHashSet();
        for (GraphObject object : this.getGraph().getObjects()) {
            if (!(object instanceof TileAggregator)) continue;
            TileAggregator proxy = (TileAggregator)object;
            inventories.addAll(proxy.connectedInventories);
        }
        aggregator.addAll(inventories);
        return aggregator;
    }

    private IEnergyStorage getCombinedPowerBuffer() {
        EnergyAggregator energy = new EnergyAggregator();
        if (this.getGraph() == null) {
            return energy;
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            TileAggregator proxy;
            IEnergyStorage internalBuffer;
            if (!(object instanceof TileAggregator) || (internalBuffer = (proxy = (TileAggregator)object).getInternalBuffer()) == null) continue;
            energy.add(internalBuffer);
        }
        return energy;
    }

    @Override
    public boolean isRemote() {
        return this.func_145831_w().field_72995_K;
    }

    @Override
    public void setDirty() {
        this.func_70296_d();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
    }

    @Override
    public void setLowOnPowerTemporary() {
        this.temporaryLowOnPowerTicks = 60;
    }

    public boolean isLowOnPower() {
        return this.temporaryLowOnPowerTicks > 0 || this.wrapper.isLowOnPower();
    }
}

