/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.driver;

import gigaherz.enderRift.automation.TileAggregator;
import gigaherz.enderRift.common.EnergyBuffer;
import gigaherz.enderRift.plugins.tesla.TeslaControllerBase;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileDriver
extends TileAggregator {
    public static final int POWER_LIMIT = 100000;
    EnergyBuffer energyBuffer = new EnergyBuffer(100000);
    private Capability teslaConsumerCap = TeslaControllerBase.CONSUMER.getCapability();
    private Object teslaConsumerInstance = TeslaControllerBase.CONSUMER.createInstance((IEnergyStorage)this.energyBuffer);
    private Capability teslaHolderCap = TeslaControllerBase.HOLDER.getCapability();
    private Object teslaHolderInstance = TeslaControllerBase.HOLDER.createInstance((IEnergyStorage)this.energyBuffer);

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            return true;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyBuffer);
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            return (T)this.teslaConsumerInstance;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return (T)this.teslaHolderInstance;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    protected void lazyDirty() {
    }

    @Override
    protected boolean canConnectSide(EnumFacing side) {
        return false;
    }

    @Override
    public IEnergyStorage getInternalBuffer() {
        return this.energyBuffer;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyBuffer, null, compound.func_74781_a("storedEnergy"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("storedEnergy", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyBuffer, null));
        return compound;
    }
}

