/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.iface;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.TileAggregator;
import gigaherz.enderRift.automation.iface.BlockInterface;
import gigaherz.enderRift.common.IPoweredAutomation;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileInterface
extends TileAggregator
implements IPoweredAutomation {
    private static final int FilterCount = 9;
    private FilterInventory filters = new FilterInventory(9);
    private ItemStackHandler outputs = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileInterface.this.func_70296_d();
        }
    };
    private EnumFacing facing = null;

    @Nullable
    public EnumFacing getFacing() {
        IBlockState state;
        if (this.facing == null && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == EnderRiftMod.riftInterface) {
            this.facing = ((EnumFacing)state.func_177229_b((IProperty)BlockInterface.FACING)).func_176734_d();
        }
        return this.facing;
    }

    public IItemHandler inventoryOutputs() {
        return this.outputs;
    }

    public IItemHandler inventoryFilter() {
        return this.filters;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing == this.getFacing() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == this.getFacing() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.outputs;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        this.facing = null;
        super.func_70296_d();
    }

    @Override
    protected boolean canConnectSide(EnumFacing side) {
        return side == this.getFacing().func_176734_d();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getCombinedInventory() == null) {
            return;
        }
        boolean anyChanged = false;
        for (int i = 0; i < 9; ++i) {
            int stackSize;
            ItemStack inFilter = this.filters.getStackInSlot(i);
            ItemStack inSlot = this.outputs.getStackInSlot(i);
            if (inFilter.func_190916_E() > 0) {
                int free;
                if (inSlot.func_190916_E() <= 0) {
                    free = 64;
                    inSlot = AutomationHelper.extractItems(this.getCombinedInventory(), inFilter, free, false);
                    this.outputs.setStackInSlot(i, inSlot);
                    if (inSlot.func_190916_E() <= 0) continue;
                    anyChanged = true;
                    continue;
                }
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)inFilter)) {
                    ItemStack extracted;
                    free = inSlot.func_77976_d() - inSlot.func_190916_E();
                    if (free <= 0 || (extracted = AutomationHelper.extractItems(this.getCombinedInventory(), inFilter, free, false)).func_190916_E() <= 0) continue;
                    inSlot.func_190917_f(extracted.func_190916_E());
                    anyChanged = true;
                    continue;
                }
                stackSize = inSlot.func_190916_E();
                inSlot = AutomationHelper.insertItems(this.getCombinedInventory(), inSlot);
                this.outputs.setStackInSlot(i, inSlot);
                if (stackSize == inSlot.func_190916_E()) continue;
                anyChanged = true;
                continue;
            }
            if (inSlot.func_190916_E() <= 0) continue;
            stackSize = inSlot.func_190916_E();
            inSlot = AutomationHelper.insertItems(this.getCombinedInventory(), inSlot);
            this.outputs.setStackInSlot(i, inSlot);
            if (stackSize == inSlot.func_190916_E()) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            this.func_70296_d();
        }
    }

    @Override
    protected void lazyDirty() {
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList _filters = compound.func_150295_c("Filters", 10);
        for (int i = 0; i < _filters.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = _filters.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.filters.getSlots()) continue;
            this.filters.setStackInSlot(j, new ItemStack(nbttagcompound));
        }
        NBTTagList _outputs = compound.func_150295_c("Outputs", 10);
        for (int i = 0; i < _outputs.func_74745_c(); ++i) {
            NBTTagCompound slot = _outputs.func_150305_b(i);
            int j = slot.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.outputs.getSlots()) continue;
            this.outputs.setStackInSlot(j, new ItemStack(slot));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList _filters = new NBTTagList();
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            ItemStack stack = this.filters.getStackInSlot(i);
            if (stack.func_190916_E() <= 0) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound);
            _filters.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Filters", (NBTBase)_filters);
        NBTTagList _outputs = new NBTTagList();
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            ItemStack stack = this.outputs.getStackInSlot(i);
            if (stack.func_190916_E() <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slot.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(slot);
            _outputs.func_74742_a((NBTBase)slot);
        }
        compound.func_74782_a("Outputs", (NBTBase)_outputs);
        return compound;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    private class FilterInventory
    implements IItemHandlerModifiable {
        final NonNullList<ItemStack> filters;

        public FilterInventory(int slotCount) {
            this.filters = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
        }

        public int getSlots() {
            return 9;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.filters.size()) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.filters.get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 0 || slot >= this.filters.size()) {
                return stack;
            }
            if (!simulate) {
                ItemStack cp = stack.func_77946_l();
                cp.func_190920_e(1);
                this.filters.set(slot, (Object)cp);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public void setStackInSlot(int index, ItemStack stack) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            this.filters.set(index, (Object)stack);
            TileInterface.this.func_70296_d();
        }
    }
}

