/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.common;

import gigaherz.enderRift.ConfigValues;
import gigaherz.enderRift.common.IPoweredAutomation;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class AutomationEnergyWrapper
implements IItemHandler {
    private final IPoweredAutomation owner;

    public AutomationEnergyWrapper(IPoweredAutomation owner) {
        this.owner = owner;
    }

    private double getEnergyInsert() {
        int sizeInventory = this.getSlots();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return Math.min(ConfigValues.PowerPerInsertionCap, ConfigValues.PowerPerInsertionConstant + (float)sizeInventory * ConfigValues.PowerPerInsertionLinear + (float)sizeInventory2 * ConfigValues.PowerPerInsertionGeometric);
    }

    private double getEnergyExtract() {
        int sizeInventory = this.getSlots();
        int sizeInventory2 = sizeInventory * sizeInventory;
        return Math.min(ConfigValues.PowerPerExtractionCap, ConfigValues.PowerPerExtractionConstant + (float)sizeInventory * ConfigValues.PowerPerExtractionLinear + (float)sizeInventory2 * ConfigValues.PowerPerExtractionGeometric);
    }

    private int getEffectivePowerUsageToInsert(int stackSize) {
        return this.owner.isRemote() ? 0 : (int)Math.ceil(this.getEnergyInsert() * (double)stackSize);
    }

    private int getEffectivePowerUsageToExtract(int limit) {
        return this.owner.isRemote() ? 0 : (int)Math.ceil(this.getEnergyExtract() * (double)limit);
    }

    public int getSlots() {
        IItemHandler inventory = this.owner.getInventory();
        return inventory != null ? inventory.getSlots() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        IItemHandler inventory = this.owner.getInventory();
        return inventory != null ? inventory.getStackInSlot(slot) : ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int stackSize;
        int cost = this.getEffectivePowerUsageToInsert(stackSize);
        IEnergyStorage energyBuffer = this.owner.getEnergyBuffer();
        IItemHandler inventory = this.owner.getInventory();
        if (inventory == null) {
            return ItemStack.field_190927_a;
        }
        boolean powerFailure = false;
        for (stackSize = stack.func_190916_E(); cost > energyBuffer.getEnergyStored() && stackSize > 0; --stackSize) {
            powerFailure = true;
        }
        if (powerFailure) {
            this.owner.setLowOnPowerTemporary();
        }
        if (stackSize <= 0) {
            return stack;
        }
        ItemStack temp = stack.func_77946_l();
        temp.func_190920_e(stackSize);
        ItemStack remaining = inventory.insertItem(slot, temp, simulate);
        if (!simulate) {
            int actualCost = this.getEffectivePowerUsageToInsert(stackSize -= remaining.func_190916_E());
            energyBuffer.extractEnergy(actualCost, false);
            this.owner.setDirty();
        }
        return remaining;
    }

    public ItemStack extractItem(int slot, int wanted, boolean simulate) {
        int cost = this.getEffectivePowerUsageToExtract(wanted);
        IEnergyStorage energyBuffer = this.owner.getEnergyBuffer();
        IItemHandler inventory = this.owner.getInventory();
        if (inventory == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = inventory.extractItem(slot, wanted, true);
        wanted = Math.min(wanted, existing.func_190916_E());
        boolean powerFailure = false;
        while (cost > energyBuffer.getEnergyStored() && wanted > 0) {
            powerFailure = true;
            cost = this.getEffectivePowerUsageToExtract(--wanted);
        }
        if (powerFailure) {
            this.owner.setLowOnPowerTemporary();
        }
        if (wanted <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = inventory.extractItem(slot, wanted, simulate);
        if (extracted.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            int actualCost = this.getEffectivePowerUsageToExtract(extracted.func_190916_E());
            energyBuffer.extractEnergy(actualCost, false);
            this.owner.setDirty();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isLowOnPower() {
        IEnergyStorage energyBuffer = this.owner.getEnergyBuffer();
        return this.getEffectivePowerUsageToExtract(1) > energyBuffer.getEnergyStored();
    }
}

