/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.generator;

import com.google.common.collect.Lists;
import gigaherz.enderRift.generator.ContainerGenerator;
import gigaherz.enderRift.generator.TileGenerator;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiGenerator
extends GuiContainer {
    private static final int bar1x = 1;
    private static final int bar2x = 17;
    private static final int barWidth = 14;
    private static final int barHeight = 42;
    protected ResourceLocation guiTextureLocation;
    protected ResourceLocation energyTextureLocation;
    protected InventoryPlayer player;
    protected TileGenerator tile;

    public GuiGenerator(InventoryPlayer playerInventory, TileGenerator tileEntity) {
        super((Container)new ContainerGenerator(tileEntity, playerInventory));
        this.player = playerInventory;
        this.tile = tileEntity;
        this.field_147000_g = 165;
        this.guiTextureLocation = new ResourceLocation("enderrift", "textures/gui/generator.png");
        this.energyTextureLocation = new ResourceLocation("enderrift", "textures/gui/energy.png");
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int i, int j) {
        String label;
        String name = I18n.func_135052_a((String)this.tile.getName(), (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(name, (this.field_146999_f - this.field_146297_k.field_71466_p.func_78256_a(name)) / 2, 6, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)this.player.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.tile.getGenerationPower() > 0) {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.generating.label", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(label, 8, 22, 0x404040);
            this.field_146297_k.field_71466_p.func_78276_b(String.format("%d RF/t", this.tile.getGenerationPower()), 12, 32, 0x404040);
        } else if (this.tile.isBurning()) {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.heating", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(label, 8, 22, 0x404040);
        } else {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.idle", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(label, 8, 22, 0x404040);
        }
        label = I18n.func_135052_a((String)"text.enderrift.generator.heat.label", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(label, 8, 46, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(String.format("%d C", this.tile.getHeatValue()), 12, 56, this.getHeatColor());
        String str = String.format("%d RF", this.tile.getContainedEnergy());
        this.field_146297_k.field_71466_p.func_78276_b(str, this.field_146999_f - 8 - this.field_146297_k.field_71466_p.func_78256_a(str), 64, 0x404040);
        this.drawBarTooltip(i, j, this.field_146999_f - 14 - 8, 20);
    }

    private void drawBarTooltip(int mx, int my, int ox, int oy) {
        int rx = mx - ox - this.field_147003_i;
        int ry = my - oy - this.field_147009_r;
        if (rx < 0 || ry < 0 || rx > 14 || ry > 42) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(I18n.func_135052_a((String)"text.enderrift.generator.energy.label", (Object[])new Object[0]));
        tooltip.add(String.format("%d / %d RF", this.tile.getContainedEnergy(), 100000));
        this.func_146283_a(tooltip, mx - this.field_147003_i, my - this.field_147009_r);
    }

    protected void func_146976_a(float f, int i, int j) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.guiTextureLocation);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isBurning()) {
            int k = this.getBurnLeftScaled(13);
            this.func_73729_b(this.field_147003_i + 80, this.field_147009_r + 36 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        this.drawEnergyBar(this.field_147003_i + this.field_146999_f - 14 - 8, this.field_147009_r + 20, this.tile.getContainedEnergy(), 100000);
    }

    private void drawEnergyBar(int x, int y, int powerLevel, int powerLimit) {
        int bar2height = 1 + powerLevel * 40 / powerLimit;
        int bar1height = 42 - bar2height;
        this.field_146297_k.field_71446_o.func_110577_a(this.energyTextureLocation);
        GuiGenerator.func_146110_a((int)x, (int)y, (float)1.0f, (float)0.0f, (int)14, (int)bar1height, (float)32.0f, (float)64.0f);
        GuiGenerator.func_146110_a((int)x, (int)(y + bar1height), (float)17.0f, (float)bar1height, (int)14, (int)bar2height, (float)32.0f, (float)64.0f);
    }

    private int getHeatColor() {
        int heatLevel = this.tile.getHeatValue();
        if (heatLevel <= 100) {
            return 0x404040;
        }
        float p = (float)(heatLevel - 100) / 900.0f;
        int r = 160;
        int g = Math.round(64.0f + 96.0f * (1.0f - p));
        int b = 64;
        return r << 16 | g << 8 | b;
    }

    private int getBurnLeftScaled(int pixels) {
        int i = this.tile.getCurrentItemBurnTime();
        if (i == 0) {
            i = 200;
        }
        return this.tile.getBurnTimeRemaining() * pixels / i;
    }
}

