/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.generator;

import gigaherz.enderRift.common.EnergyBuffer;
import gigaherz.enderRift.plugins.tesla.TeslaControllerBase;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGenerator
extends TileEntity
implements ITickable {
    public static final int SLOT_COUNT = 1;
    public static final int POWER_LIMIT = 100000;
    public static final int MIN_HEAT = 100;
    public static final int MAX_HEAT = 1000;
    public static final int POWERGEN_MIN = 20;
    public static final int POWERGEN_MAX = 200;
    public static final int HEAT_INTERVAL = 20;
    public static final int POWER_TRANSFER_MAX = 800;
    private EnergyBuffer energyCapability = new EnergyBuffer(100000);
    private final ItemStackHandler fuelSlot = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileGenerator.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public int heatLevel;
    public int burnTimeRemaining;
    public int currentItemBurnTime;
    public int timeInterval;
    private Capability teslaProducerCap = TeslaControllerBase.PRODUCER.getCapability();
    private Capability teslaHolderCap;
    private Object teslaProducerInstance = TeslaControllerBase.PRODUCER.createInstance((IEnergyStorage)this.energyCapability);
    private Object teslaHolderInstance;

    public TileGenerator() {
        this.teslaHolderCap = TeslaControllerBase.HOLDER.getCapability();
        this.teslaHolderInstance = TeslaControllerBase.HOLDER.createInstance((IEnergyStorage)this.energyCapability);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.teslaProducerCap != null && capability == this.teslaProducerCap) {
            return true;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyCapability);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.fuelSlot;
        }
        if (this.teslaProducerCap != null && capability == this.teslaProducerCap) {
            return (T)this.teslaProducerInstance;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return (T)this.teslaHolderInstance;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean anyChanged = this.updateGeneration();
        if (anyChanged |= this.transferPower()) {
            this.func_70296_d();
        }
    }

    private boolean updateGeneration() {
        ItemStack stack;
        boolean anyChanged = false;
        int minHeatLevel = 0;
        int heatInterval = 20;
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150353_l && this.heatLevel < (minHeatLevel = 99)) {
            heatInterval = Math.max(1, heatInterval / 2);
        }
        if (this.timeInterval < 20) {
            ++this.timeInterval;
        }
        if (this.burnTimeRemaining > 0) {
            this.burnTimeRemaining -= Math.max(1, this.heatLevel / 100);
            if (this.burnTimeRemaining <= 0) {
                this.timeInterval = 0;
            }
            if (this.timeInterval >= heatInterval && this.heatLevel < 1000) {
                this.timeInterval = 0;
                ++this.heatLevel;
                anyChanged = true;
            }
        } else if (this.heatLevel > minHeatLevel) {
            if (this.timeInterval >= 20) {
                this.timeInterval = 0;
                --this.heatLevel;
                anyChanged = true;
            }
        } else if (minHeatLevel > 0 && this.heatLevel < minHeatLevel && this.timeInterval >= 20) {
            this.timeInterval = 0;
            ++this.heatLevel;
            anyChanged = true;
        }
        if (this.heatLevel >= 100 && this.energyCapability.getEnergyStored() < 100000) {
            int powerGen = this.getGenerationPower();
            this.energyCapability.setEnergy(Math.min(this.energyCapability.getEnergyStored() + powerGen, 100000));
            anyChanged = true;
        }
        if (this.burnTimeRemaining <= 0 && this.energyCapability.getEnergyStored() < 100000 && (stack = this.fuelSlot.getStackInSlot(0)).func_190916_E() > 0) {
            this.currentItemBurnTime = this.burnTimeRemaining = TileEntityFurnace.func_145952_a((ItemStack)this.fuelSlot.getStackInSlot(0));
            this.timeInterval = 0;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                this.fuelSlot.setStackInSlot(0, stack.func_77973_b().getContainerItem(stack));
            }
            anyChanged = true;
        }
        return anyChanged;
    }

    private boolean transferPower() {
        boolean anyChanged = false;
        int sendPower = Math.min(800, this.energyCapability.getEnergyStored());
        if (sendPower > 0) {
            IEnergyStorage[] handlers = new IEnergyStorage[6];
            int[] wantedSide = new int[6];
            int accepted = 0;
            for (EnumFacing neighbor : EnumFacing.field_82609_l) {
                int wanted;
                TileEntity e = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(neighbor));
                EnumFacing from = neighbor.func_176734_d();
                if (e == null) continue;
                IEnergyStorage handler = null;
                if (e.hasCapability(CapabilityEnergy.ENERGY, from) && !(handler = (IEnergyStorage)e.getCapability(CapabilityEnergy.ENERGY, from)).canReceive()) {
                    handler = null;
                }
                if (handler == null) {
                    handler = TeslaControllerBase.CONSUMER.wrapReverse(e, from);
                }
                if (handler == null) continue;
                handlers[from.ordinal()] = handler;
                wantedSide[from.ordinal()] = wanted = handler.receiveEnergy(sendPower, true);
                accepted += wanted;
            }
            if (accepted > 0) {
                for (EnumFacing from : EnumFacing.field_82609_l) {
                    IEnergyStorage handler = handlers[from.ordinal()];
                    int wanted = wantedSide[from.ordinal()];
                    if (handler == null || wanted == 0) continue;
                    int given = Math.min(Math.min(this.energyCapability.getEnergyStored(), wanted), wanted * accepted / sendPower);
                    int received = Math.min(given, handler.receiveEnergy(given, false));
                    this.energyCapability.setEnergy(this.energyCapability.getEnergyStored() - received);
                    if (this.energyCapability.getEnergyStored() <= 0) break;
                }
                anyChanged = true;
            }
        }
        return anyChanged;
    }

    public String getName() {
        return "container.enderrift.generator";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.heatLevel = compound.func_74762_e("heatLevel");
        this.burnTimeRemaining = compound.func_74762_e("burnTimeRemaining");
        this.currentItemBurnTime = compound.func_74762_e("currentItemBurnTime");
        this.timeInterval = compound.func_74762_e("timeInterval");
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyCapability, null, compound.func_74781_a("storedEnergy"));
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.fuelSlot, null, (NBTBase)compound.func_150295_c("fuelSlot", 10));
        if (compound.func_150297_b("Items", 9)) {
            NBTTagList _outputs = compound.func_150295_c("Items", 10);
            for (int i = 0; i < _outputs.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = _outputs.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.fuelSlot.getSlots()) continue;
                this.fuelSlot.setStackInSlot(j, new ItemStack(nbttagcompound));
            }
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("heatLevel", this.heatLevel);
        compound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining);
        compound.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        compound.func_74768_a("timeInterval", this.timeInterval);
        compound.func_74782_a("storedEnergy", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyCapability, null));
        compound.func_74782_a("fuelSlot", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.fuelSlot, null));
        return compound;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int[] getFields() {
        return new int[]{this.burnTimeRemaining, this.currentItemBurnTime, this.energyCapability.getEnergyStored(), this.heatLevel};
    }

    public void setFields(int[] values) {
        this.burnTimeRemaining = values[0];
        this.currentItemBurnTime = values[1];
        this.energyCapability.setEnergy(values[2]);
        this.heatLevel = values[3];
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public int getHeatValue() {
        return this.heatLevel;
    }

    public int getGenerationPower() {
        if (this.heatLevel < 100) {
            return 0;
        }
        return Math.max(0, Math.round(20.0f + (float)(180 * (this.heatLevel - 100)) / 900.0f));
    }

    public int getContainedEnergy() {
        return this.energyCapability.getEnergyStored();
    }

    public IItemHandler inventory() {
        return this.fuelSlot;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }
}

