/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.plugins;

import com.google.common.base.Function;
import gigaherz.enderRift.automation.driver.TileDriver;
import gigaherz.enderRift.generator.TileGenerator;
import gigaherz.enderRift.rift.TileEnderRift;
import gigaherz.enderRift.rift.TileEnderRiftCorner;
import gigaherz.graph.api.Graph;
import gigaherz.graph.api.GraphObject;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TheOneProbeProviders
implements Function<ITheOneProbe, Void> {
    private static final int RF_COLOR_B = -13697024;
    private static final int RF_COLOR_F1 = -7405568;
    private static final int RF_COLOR_F2 = -9502720;
    private static final int HEAT_LOW = -9502720;
    private static final IProgressStyle RF_STYLE = new ProgressStyle().suffix(" RF").backgroundColor(-13697024).filledColor(-7405568).alternateFilledColor(-9502720);

    public Void apply(@Nullable ITheOneProbe top) {
        assert (top != null);
        top.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "enderrift_Probes";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                TileEntity te = world.func_175625_s(data.getPos());
                if (te instanceof TileEnderRift || te instanceof TileEnderRiftCorner) {
                    TheOneProbeProviders.handleRiftTooltip(mode, probeInfo, te);
                }
                if (te instanceof TileDriver) {
                    TheOneProbeProviders.handleDriver(mode, probeInfo, te);
                }
                if (te instanceof TileGenerator) {
                    TheOneProbeProviders.handleGenerator(mode, probeInfo, te);
                }
                if (te instanceof GraphObject) {
                    TheOneProbeProviders.handleGraphObject(mode, probeInfo, te);
                }
            }
        });
        return null;
    }

    private static int ilerp(int a, int b, int p, int m) {
        return a + (b - a) * p / m;
    }

    public static IProgressStyle getTemperatureColor(int current, int min, int max) {
        int c = -9502720;
        if (current >= min) {
            int r = TheOneProbeProviders.ilerp(0, 255, current - min, max - min);
            int g = TheOneProbeProviders.ilerp(128, 192, current - min, max - min);
            c = 0xFF000000 | r << 16 | g << 8;
        }
        return new ProgressStyle().suffix("\u00b0C").filledColor(c).alternateFilledColor(c);
    }

    private static void handleGenerator(ProbeMode mode, IProbeInfo info, TileEntity te) {
        TileGenerator generator = (TileGenerator)te;
        int powerGen = generator.getGenerationPower();
        if (powerGen > 0) {
            info.text(I18n.func_135052_a((String)"text.enderrift.generator.status.generating", (Object[])new Object[]{powerGen}));
        } else if (generator.isBurning()) {
            info.text(I18n.func_135052_a((String)"text.enderrift.generator.status.heating", (Object[])new Object[0]));
        } else {
            info.text(I18n.func_135052_a((String)"text.enderrift.generator.status.idle", (Object[])new Object[0]));
        }
        int heat = generator.getHeatValue();
        info.progress(heat, 1000, TheOneProbeProviders.getTemperatureColor(heat, 100, 1000));
        info.progress(generator.getContainedEnergy(), 100000, RF_STYLE);
    }

    private static void handleDriver(ProbeMode mode, IProbeInfo info, TileEntity te) {
        TileDriver driver = (TileDriver)te;
        info.progress(driver.getInternalBuffer().getEnergyStored(), 100000, RF_STYLE);
    }

    private static void handleGraphObject(ProbeMode mode, IProbeInfo info, TileEntity te) {
        Graph network = ((GraphObject)te).getGraph();
        info.text(String.format("Network size: %d", network.getObjects().size()));
    }

    private static void handleRiftTooltip(ProbeMode mode, IProbeInfo info, TileEntity te) {
        boolean isFormed;
        TileEnderRift rift = te instanceof TileEnderRiftCorner ? ((TileEnderRiftCorner)te).getParent() : (TileEnderRift)te;
        assert (rift != null);
        boolean bl = isFormed = rift.func_145832_p() != 0;
        if (isFormed) {
            info.text(I18n.func_135052_a((String)"text.enderrift.rift.isFormed", (Object[])new Object[]{true}));
            info.text(I18n.func_135052_a((String)"text.enderrift.rift.isPowered", (Object[])new Object[]{rift.isPowered()}));
            info.text(I18n.func_135052_a((String)"text.enderrift.rift.riftId", (Object[])new Object[]{rift.getRiftId()}));
            info.text(I18n.func_135052_a((String)"text.enderrift.rift.usedSlots", (Object[])new Object[]{rift.countInventoryStacks()}));
            info.progress(rift.getEnergyBuffer().getEnergyStored(), 1000000, RF_STYLE);
        } else {
            info.text(I18n.func_135052_a((String)"text.enderrift.rift.waila.isFormed", (Object[])new Object[]{false}));
        }
    }
}

