/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.rift.BlockEnderRift;
import gigaherz.enderRift.rift.BlockStructure;
import gigaherz.enderRift.rift.TileEnderRift;
import gigaherz.enderRift.rift.storage.RiftStorageWorldData;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RiftStructure {
    static Block[] StructurePattern;
    static IBlockState[] StructureStates;

    public static void init() {
        StructurePattern = new Block[]{Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, null, EnderRiftMod.rift, null, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S};
        StructureStates = new IBlockState[]{EnderRiftMod.structure.cornerState(BlockStructure.Corner.NW, true), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_EW, true), EnderRiftMod.structure.cornerState(BlockStructure.Corner.NE, true), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_NS, true), null, EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_NS, true), EnderRiftMod.structure.cornerState(BlockStructure.Corner.SW, true), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_EW, true), EnderRiftMod.structure.cornerState(BlockStructure.Corner.SE, true), EnderRiftMod.structure.edgeState(BlockStructure.Type2.VERTICAL, false), null, EnderRiftMod.structure.edgeState(BlockStructure.Type2.VERTICAL, false), null, null, null, EnderRiftMod.structure.edgeState(BlockStructure.Type2.VERTICAL, false), null, EnderRiftMod.structure.edgeState(BlockStructure.Type2.VERTICAL, false), EnderRiftMod.structure.cornerState(BlockStructure.Corner.NW, false), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_EW, false), EnderRiftMod.structure.cornerState(BlockStructure.Corner.NE, false), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_NS, false), null, EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_NS, false), EnderRiftMod.structure.cornerState(BlockStructure.Corner.SW, false), EnderRiftMod.structure.edgeState(BlockStructure.Type2.SIDE_EW, false), EnderRiftMod.structure.cornerState(BlockStructure.Corner.SE, false)};
    }

    public static boolean duplicateOrb(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEnderRift)) {
            return false;
        }
        ItemStack stack = ((TileEnderRift)te).getRiftItem();
        EntityItem entity = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
        world.func_72838_d((Entity)entity);
        return true;
    }

    public static void breakStructure(World world, BlockPos pos) {
        for (int yy = -1; yy <= 1; ++yy) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos pos2 = pos.func_177982_a(xx, yy, zz);
                    if (world.func_180495_p(pos2).func_177230_c() != EnderRiftMod.rift) continue;
                    RiftStructure.dismantle(world, pos2);
                    return;
                }
            }
        }
    }

    public static boolean assemble(World world, BlockPos pos, ItemStack itemStack) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != EnderRiftMod.rift) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockEnderRift.ASSEMBLED)).booleanValue()) {
            return false;
        }
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    IBlockState st;
                    BlockPos bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1);
                    Block b = StructurePattern[yy * 9 + zz * 3 + xx];
                    Block w = world.func_180495_p(bp).func_177230_c();
                    if (b == null || !(b == Blocks.field_150350_a ? !w.isAir(st = world.func_180495_p(bp), (IBlockAccess)world, bp) : b != EnderRiftMod.rift && b != w)) continue;
                    return false;
                }
            }
        }
        RiftStructure.buildStructure(world, pos, itemStack, state);
        return true;
    }

    private static void buildStructure(World world, BlockPos pos, ItemStack itemStack, IBlockState state) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    IBlockState bs = StructureStates[yy * 9 + zz * 3 + xx];
                    if (bs == null) continue;
                    BlockPos bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1);
                    world.func_175656_a(bp, bs);
                }
            }
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnderRift.ASSEMBLED, (Comparable)Boolean.valueOf(true)));
        TileEnderRift rift = (TileEnderRift)world.func_175625_s(pos);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("RiftId")) {
            rift.assemble(tagCompound.func_74762_e("RiftId"));
        } else {
            rift.assemble(RiftStorageWorldData.get(world).getNextRiftId());
        }
    }

    public static void dismantle(World world, BlockPos pos) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockPos bp;
                    Block b = StructurePattern[yy * 9 + zz * 3 + xx];
                    if (b == null || b == Blocks.field_150350_a || b == EnderRiftMod.rift || world.func_180495_p(bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1)).func_177230_c() != EnderRiftMod.structure) continue;
                    world.func_175656_a(bp, b.func_176223_P());
                }
            }
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == EnderRiftMod.rift && ((Boolean)state.func_177229_b((IProperty)BlockEnderRift.ASSEMBLED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnderRift.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
            TileEnderRift rift = (TileEnderRift)world.func_175625_s(pos);
            ItemStack stack = rift.getRiftItem();
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)entity);
            rift.unassemble();
        }
    }

    public static Block getOriginalBlock(World worldIn, BlockPos pos) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockPos pos2 = pos.func_177982_a(1 - xx, 1 - yy, 1 - zz);
                    if (worldIn.func_180495_p(pos2).func_177230_c() != EnderRiftMod.rift) continue;
                    return StructurePattern[yy * 9 + zz * 3 + xx];
                }
            }
        }
        return null;
    }
}

