/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.common.EnergyBuffer;
import gigaherz.enderRift.rift.storage.RiftInventory;
import gigaherz.enderRift.rift.storage.RiftStorageWorldData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEnderRift
extends TileEntity
implements ITickable {
    private static final int STARTUP_POWER = 10000;
    public static final int BUFFER_POWER = 1000000;
    private final Random rand = new Random();
    private EnergyBuffer energyBuffer = new EnergyBuffer(1000000);
    private boolean powered;
    private int riftId;
    private RiftInventory inventory;
    private float lastPoweringState;
    private float poweringState;
    private boolean poweringStartParticlesSpawned = false;
    public PoweredInventory poweredInventory = new PoweredInventory();

    public EnergyBuffer getEnergyBuffer() {
        return this.energyBuffer;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastPoweringState = this.poweringState;
            if (this.powered) {
                if (!this.poweringStartParticlesSpawned) {
                    this.poweringStartParticlesSpawned = true;
                    for (int i = 0; i < 32; ++i) {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.rand.nextGaussian(), this.rand.nextGaussian(), this.rand.nextGaussian(), new int[0]);
                        this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.rand.nextGaussian(), this.rand.nextGaussian(), this.rand.nextGaussian(), new int[0]);
                    }
                }
                this.poweringState = this.poweringState < 1.0f ? (this.poweringState += 0.1f) : 1.0f;
            } else {
                this.poweringStartParticlesSpawned = false;
                this.poweringState = this.poweringState > 0.0f ? (this.poweringState -= 0.02f) : 0.0f;
            }
            return;
        }
        int energyUsage = this.getEnergyUsage();
        int energyStored = this.energyBuffer.getEnergyStored();
        if (energyStored > this.energyBuffer.getMaxEnergyStored()) {
            energyStored = this.energyBuffer.getMaxEnergyStored();
            this.energyBuffer.setEnergy(energyStored);
        }
        if (energyStored > energyUsage && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (this.powered) {
                this.energyBuffer.setEnergy(energyStored - energyUsage);
            } else if (energyStored >= 10000) {
                this.powered = true;
                this.energyBuffer.setEnergy(energyStored - 10000);
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        } else {
            this.powered = false;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void assemble(int id) {
        this.inventory = null;
        this.riftId = id;
        this.func_70296_d();
    }

    public void unassemble() {
        this.inventory = null;
        this.riftId = -1;
        this.func_70296_d();
    }

    @Nullable
    public IItemHandler getInventory() {
        if (this.riftId < 0) {
            return null;
        }
        if (this.inventory == null) {
            this.inventory = RiftStorageWorldData.get(this.field_145850_b).getRift(this.riftId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int countInventoryStacks() {
        return this.getInventory().getSlots();
    }

    public ItemStack getRiftItem() {
        ItemStack stack = new ItemStack(EnderRiftMod.riftOrb);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("RiftId", this.riftId);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energyBuffer.setEnergy(compound.func_74762_e("Energy"));
        this.powered = compound.func_74767_n("Powered");
        this.riftId = compound.func_74762_e("RiftId");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("Energy", this.energyBuffer.getEnergyStored());
        compound.func_74757_a("Powered", this.powered);
        compound.func_74768_a("RiftId", this.riftId);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("Powered", this.powered);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.powered = tag.func_74767_n("Powered");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.poweredInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public ItemStack chooseRandomStack() {
        if (this.getInventory() == null) {
            return ItemStack.field_190927_a;
        }
        int max = this.getInventory().getSlots();
        if (max <= 0) {
            return ItemStack.field_190927_a;
        }
        int slot = this.rand.nextInt(max);
        return this.poweredInventory.getStackInSlot(slot);
    }

    public int getRiftId() {
        return this.riftId;
    }

    public int getEnergyUsage() {
        IItemHandler handler = this.getInventory();
        if (handler == null) {
            return 0;
        }
        return MathHelper.func_76143_f((double)Math.pow(handler.getSlots(), 0.8));
    }

    public boolean isPowered() {
        return this.powered;
    }

    public float getPoweringState() {
        return this.poweringState;
    }

    public float getLastPoweringState() {
        return this.lastPoweringState;
    }

    public class PoweredInventory
    implements IItemHandler {
        public int getSlots() {
            IItemHandler handler = TileEnderRift.this.getInventory();
            if (handler == null) {
                return 0;
            }
            return handler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (!TileEnderRift.this.powered) {
                return ItemStack.field_190927_a;
            }
            IItemHandler handler = TileEnderRift.this.getInventory();
            if (handler == null) {
                return ItemStack.field_190927_a;
            }
            return handler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!TileEnderRift.this.powered) {
                return stack;
            }
            IItemHandler handler = TileEnderRift.this.getInventory();
            if (handler == null) {
                return stack;
            }
            return handler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!TileEnderRift.this.powered) {
                return ItemStack.field_190927_a;
            }
            IItemHandler handler = TileEnderRift.this.getInventory();
            if (handler == null) {
                return ItemStack.field_190927_a;
            }
            return handler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

