/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.TileAggregator;
import gigaherz.enderRift.plugins.tesla.TeslaControllerBase;
import gigaherz.enderRift.rift.BlockStructure;
import gigaherz.enderRift.rift.TileEnderRift;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEnderRiftCorner
extends TileAggregator {
    TileEnderRift energyParent;
    private Capability teslaConsumerCap = TeslaControllerBase.CONSUMER.getCapability();
    private Object teslaConsumerInstance;
    private Capability teslaHolderCap = TeslaControllerBase.HOLDER.getCapability();
    private Object teslaHolderInstance;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        IEnergyStorage buffer = this.getEnergyBuffer();
        if (capability == CapabilityEnergy.ENERGY) {
            return buffer != null;
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            return buffer != null;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            return buffer != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        IEnergyStorage buffer = this.getEnergyBuffer();
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)buffer;
        }
        if (this.teslaConsumerCap != null && capability == this.teslaConsumerCap) {
            if (this.teslaConsumerInstance == null && buffer != null) {
                this.teslaConsumerInstance = TeslaControllerBase.CONSUMER.createInstance(this.getEnergyBuffer());
            }
            return (T)this.teslaConsumerInstance;
        }
        if (this.teslaHolderCap != null && capability == this.teslaHolderCap) {
            if (this.teslaHolderInstance == null && buffer != null) {
                this.teslaHolderInstance = TeslaControllerBase.HOLDER.createInstance(this.getEnergyBuffer());
            }
            return (T)this.teslaHolderInstance;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyBuffer() {
        return this.getInternalBuffer();
    }

    @Override
    @Nullable
    public IEnergyStorage getInternalBuffer() {
        TileEnderRift parent = this.getParent();
        return parent != null ? parent.getEnergyBuffer() : null;
    }

    @Override
    protected void lazyDirty() {
    }

    @Override
    protected boolean canConnectSide(EnumFacing side) {
        return false;
    }

    @Nullable
    public TileEnderRift getParent() {
        if (this.energyParent == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != EnderRiftMod.structure) {
                return null;
            }
            TileEntity te = this.field_145850_b.func_175625_s(TileEnderRiftCorner.getRiftFromCorner(state, this.field_174879_c));
            if (te instanceof TileEnderRift) {
                this.energyParent = (TileEnderRift)te;
            } else {
                return null;
            }
        }
        return this.energyParent;
    }

    private static BlockPos getRiftFromCorner(IBlockState state, BlockPos pos) {
        boolean base = (Boolean)state.func_177229_b((IProperty)BlockStructure.BASE);
        BlockStructure.Corner corner = (BlockStructure.Corner)((Object)state.func_177229_b(BlockStructure.CORNER));
        int xParent = pos.func_177958_n();
        int yParent = pos.func_177956_o() + (base ? 1 : -1);
        int zParent = pos.func_177952_p();
        switch (corner) {
            case NE: {
                --xParent;
                ++zParent;
                break;
            }
            case NW: {
                ++xParent;
                ++zParent;
                break;
            }
            case SE: {
                --xParent;
                --zParent;
                break;
            }
            case SW: {
                ++xParent;
                --zParent;
            }
        }
        return new BlockPos(xParent, yParent, zParent);
    }
}

