/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift.storage;

import com.google.common.collect.Lists;
import gigaherz.enderRift.rift.TileEnderRift;
import gigaherz.enderRift.rift.storage.RiftStorageWorldData;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class RiftInventory
implements IItemHandler {
    private final RiftStorageWorldData manager;
    final List<Reference<? extends TileEnderRift>> listeners = Lists.newArrayList();
    final ReferenceQueue<TileEnderRift> deadListeners = new ReferenceQueue();
    private final List<ItemStack> inventorySlots = Lists.newArrayList();

    RiftInventory(RiftStorageWorldData manager) {
        this.manager = manager;
    }

    public void addWeakListener(TileEnderRift e) {
        this.listeners.add(new WeakReference<TileEnderRift>(e, this.deadListeners));
    }

    private void onContentsChanged() {
        Reference<TileEnderRift> ref = this.deadListeners.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.deadListeners.poll();
        }
        Iterator<Reference<? extends TileEnderRift>> it = this.listeners.iterator();
        while (it.hasNext()) {
            TileEnderRift rift = it.next().get();
            if (rift == null || rift.func_145837_r()) {
                it.remove();
                continue;
            }
            rift.func_70296_d();
        }
        this.manager.func_76185_a();
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventorySlots.clear();
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slot = itemList.func_150305_b(i);
            this.inventorySlots.add(new ItemStack(slot));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (ItemStack stack : this.inventorySlots) {
            if (stack == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            stack.func_77955_b(slot);
            itemList.func_74742_a((NBTBase)slot);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public int getSlots() {
        return this.inventorySlots.size() + 1;
    }

    public ItemStack getStackInSlot(int index) {
        if (index >= this.inventorySlots.size()) {
            return ItemStack.field_190927_a;
        }
        return this.inventorySlots.get(index);
    }

    public ItemStack insertItem(int index, ItemStack stack, boolean simulate) {
        if (index >= this.inventorySlots.size()) {
            if (!simulate) {
                this.inventorySlots.add(stack.func_77946_l());
                this.onContentsChanged();
            }
            return ItemStack.field_190927_a;
        }
        ItemStack remaining = stack.func_77946_l();
        ItemStack slot = this.inventorySlots.get(index);
        if (slot.func_190916_E() > 0) {
            int max = Math.min(remaining.func_77976_d(), 64);
            int transfer = Math.min(remaining.func_190916_E(), max - slot.func_190916_E());
            if (transfer > 0 && ItemHandlerHelper.canItemStacksStack((ItemStack)remaining, (ItemStack)slot)) {
                if (!simulate) {
                    slot.func_190917_f(transfer);
                }
                remaining.func_190918_g(transfer);
                if (remaining.func_190916_E() <= 0) {
                    remaining = ItemStack.field_190927_a;
                }
            }
        }
        if (!simulate) {
            this.onContentsChanged();
        }
        return remaining;
    }

    public ItemStack extractItem(int index, int wanted, boolean simulate) {
        if (index >= this.inventorySlots.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slot = this.inventorySlots.get(index);
        if (slot == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack _extracted = slot.func_77946_l();
        int extractedCount = 0;
        int available = Math.min(wanted, slot.func_190916_E());
        if (available > 0) {
            extractedCount += available;
            if (!simulate) {
                slot.func_190918_g(available);
                if (slot.func_190916_E() <= 0) {
                    this.inventorySlots.remove(index);
                }
            }
        }
        if (extractedCount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.onContentsChanged();
        }
        _extracted.func_190920_e(extractedCount);
        return _extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

