/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift.storage;

import gigaherz.enderRift.rift.storage.RiftInventory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class RiftStorageWorldData
extends WorldSavedData {
    private static final String StorageKey = "enderRiftStorageManager";
    private Map<Integer, RiftInventory> rifts = new HashMap<Integer, RiftInventory>();
    private int lastRiftId;

    public RiftStorageWorldData() {
        super(StorageKey);
    }

    public RiftStorageWorldData(String s) {
        super(s);
    }

    public static RiftStorageWorldData get(World world) {
        MapStorage storage = world.func_175693_T();
        RiftStorageWorldData instance = (RiftStorageWorldData)storage.func_75742_a(RiftStorageWorldData.class, StorageKey);
        if (instance == null) {
            instance = new RiftStorageWorldData();
            storage.func_75745_a(StorageKey, (WorldSavedData)instance);
        }
        return instance;
    }

    public RiftInventory getRift(int id) {
        RiftInventory rift = this.rifts.get(id);
        if (rift == null) {
            rift = new RiftInventory(this);
            this.rifts.put(id, rift);
        }
        return rift;
    }

    public int getNextRiftId() {
        this.func_76185_a();
        return ++this.lastRiftId;
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Rifts", 10);
        this.rifts.clear();
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound1 = nbtTagList.func_150305_b(i);
            byte j = nbtTagCompound1.func_74771_c("Rift");
            RiftInventory inventory = new RiftInventory(this);
            inventory.readFromNBT(nbtTagCompound1);
            this.rifts.put(Integer.valueOf(j), inventory);
        }
        this.lastRiftId = nbtTagCompound.func_74762_e("LastRiftId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbtTagCompound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (Map.Entry<Integer, RiftInventory> entry : this.rifts.entrySet()) {
            RiftInventory inventory = entry.getValue();
            NBTTagCompound nbtTagCompound1 = new NBTTagCompound();
            nbtTagCompound1.func_74768_a("Rift", entry.getKey().intValue());
            inventory.writeToNBT(nbtTagCompound1);
            nbtTagList.func_74742_a((NBTBase)nbtTagCompound1);
        }
        nbtTagCompound.func_74782_a("Rifts", (NBTBase)nbtTagList);
        nbtTagCompound.func_74768_a("LastRiftId", this.lastRiftId);
        return nbtTagCompound;
    }
}

