/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import gigaherz.enderRift.automation.AggregatorTileEntity;
import gigaherz.enderRift.automation.AutomationHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AggregatorBlock<T extends AggregatorTileEntity>
extends Block {
    protected AggregatorBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos otherPos, boolean p_220069_6_) {
        super.func_220069_a(state, world, pos, otherBlock, otherPos, p_220069_6_);
        TileEntity teSelf = world.func_175625_s(pos);
        if (!(teSelf instanceof AggregatorTileEntity)) {
            return;
        }
        ((AggregatorTileEntity)teSelf).updateNeighbours();
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        this.recheckNeighbour((IBlockReader)world, pos, neighbor);
    }

    protected void recheckNeighbour(IBlockReader world, BlockPos pos, BlockPos neighbor) {
        Direction side = null;
        if (neighbor.equals((Object)pos.func_177974_f())) {
            side = Direction.EAST;
        }
        if (neighbor.equals((Object)pos.func_177976_e())) {
            side = Direction.WEST;
        }
        if (neighbor.equals((Object)pos.func_177978_c())) {
            side = Direction.NORTH;
        }
        if (neighbor.equals((Object)pos.func_177968_d())) {
            side = Direction.SOUTH;
        }
        if (neighbor.equals((Object)pos.func_177984_a())) {
            side = Direction.UP;
        }
        if (neighbor.equals((Object)pos.func_177977_b())) {
            side = Direction.DOWN;
        }
        if (side != null && this.isAutomatable(world, pos, side)) {
            TileEntity teSelf = world.func_175625_s(pos);
            if (!(teSelf instanceof AggregatorTileEntity)) {
                return;
            }
            ((AggregatorTileEntity)teSelf).updateConnectedInventories();
        }
    }

    protected boolean isAutomatable(IBlockReader worldIn, BlockPos pos, Direction facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        if (te == null) {
            return false;
        }
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }

    protected boolean isConnectableAutomation(IBlockReader worldIn, BlockPos pos, Direction facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        if (te == null) {
            return false;
        }
        if (te instanceof AggregatorTileEntity) {
            return true;
        }
        return AutomationHelper.isAutomatable(te, facing.func_176734_d());
    }
}

