/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.EnergyAggregator;
import gigaherz.enderRift.automation.InventoryAggregator;
import gigaherz.enderRift.common.AutomationEnergyWrapper;
import gigaherz.enderRift.common.IPoweredAutomation;
import gigaherz.enderRift.shadow.graphlib2.Graph;
import gigaherz.enderRift.shadow.graphlib2.GraphObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class AggregatorTileEntity
extends TileEntity
implements ITickableTileEntity,
GraphObject,
IPoweredAutomation {
    private Graph graph;
    private boolean firstUpdate = true;
    private final List<IItemHandler> connectedInventories = Lists.newArrayList();
    private AutomationEnergyWrapper wrapper = new AutomationEnergyWrapper(this);
    private int temporaryLowOnPowerTicks = 0;

    public AggregatorTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    @Nullable
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void func_73660_a() {
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.init();
        }
        if (this.temporaryLowOnPowerTicks > 0) {
            --this.temporaryLowOnPowerTicks;
        }
    }

    private void init() {
        Graph.integrate(this, this.getNeighbours());
        this.updateConnectedInventories();
    }

    public void func_145843_s() {
        super.func_145843_s();
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.remove(this);
        }
    }

    void updateNeighbours() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.addDirectedEdges(this, this.getNeighbours());
        }
        this.updateConnectedInventories();
    }

    private List<GraphObject> getNeighbours() {
        ArrayList neighbours = Lists.newArrayList();
        for (Direction f : Direction.values()) {
            AggregatorTileEntity thingOther;
            TileEntity teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            if (!(teOther instanceof AggregatorTileEntity) || (thingOther = (AggregatorTileEntity)teOther).getGraph() == null) continue;
            neighbours.add(thingOther);
        }
        return neighbours;
    }

    public void lazyNotifyDirty() {
        if (this.getGraph() == null) {
            return;
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            AggregatorTileEntity other;
            if (!(object instanceof AggregatorTileEntity) || (other = (AggregatorTileEntity)object).func_145837_r()) continue;
            other.lazyDirty();
        }
    }

    @Override
    @Nullable
    public IItemHandler getInventory() {
        return this.getCombinedInventoryInternal();
    }

    @Override
    public Optional<IEnergyStorage> getEnergyBuffer() {
        return this.getCombinedPowerBuffer();
    }

    protected abstract void lazyDirty();

    protected void updateConnectedInventories() {
        this.connectedInventories.clear();
        for (Direction f : Direction.values()) {
            TileEntity teOther;
            if (!this.canConnectSide(f) || (teOther = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f))) == null || teOther instanceof AggregatorTileEntity || !AutomationHelper.isAutomatable(teOther, f.func_176734_d())) continue;
            teOther.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f.func_176734_d()).ifPresent(this.connectedInventories::add);
        }
        this.lazyNotifyDirty();
    }

    protected abstract boolean canConnectSide(Direction var1);

    public IItemHandler getCombinedInventory() {
        return this.wrapper;
    }

    public Optional<IEnergyStorage> getInternalBuffer() {
        return Optional.empty();
    }

    private IItemHandler getCombinedInventoryInternal() {
        InventoryAggregator aggregator = new InventoryAggregator();
        if (this.getGraph() == null) {
            return aggregator;
        }
        HashSet inventories = Sets.newHashSet();
        for (GraphObject object : this.getGraph().getObjects()) {
            if (!(object instanceof AggregatorTileEntity)) continue;
            AggregatorTileEntity proxy = (AggregatorTileEntity)object;
            inventories.addAll(proxy.connectedInventories);
        }
        aggregator.addAll(inventories);
        return aggregator;
    }

    private Optional<IEnergyStorage> getCombinedPowerBuffer() {
        EnergyAggregator energy = new EnergyAggregator();
        if (this.getGraph() == null) {
            return Optional.of(energy);
        }
        for (GraphObject object : this.getGraph().getObjects()) {
            if (!(object instanceof AggregatorTileEntity)) continue;
            AggregatorTileEntity proxy = (AggregatorTileEntity)object;
            proxy.getInternalBuffer().ifPresent(energy::add);
        }
        return Optional.of(energy);
    }

    @Override
    public boolean isRemote() {
        return this.func_145831_w().field_72995_K;
    }

    @Override
    public void setDirty() {
        this.func_70296_d();
    }

    public void handleUpdateTag(CompoundNBT tag) {
    }

    @Override
    public void setLowOnPowerTemporary() {
        this.temporaryLowOnPowerTicks = 60;
    }

    public boolean isLowOnPower() {
        return this.temporaryLowOnPowerTicks > 0 || this.wrapper.isLowOnPower();
    }
}

