/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.browser;

import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.enderRift.automation.browser.AbstractBrowserContainer;
import gigaherz.enderRift.automation.browser.SortMode;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractBrowserScreen<T extends AbstractBrowserContainer>
extends ContainerScreen<T> {
    private static final ResourceLocation backgroundTexture = new ResourceLocation("enderrift", "textures/gui/browser.png");
    private static final ResourceLocation tabsTexture = new ResourceLocation("minecraft:textures/gui/container/creative_inventory/tabs.png");
    private boolean isDragging;
    private int scrollY;
    private float scrollAcc = 0.0f;
    private TextFieldWidget searchField;
    private Button sortModeButton;

    protected AbstractBrowserScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_146999_f = 194;
        this.field_147000_g = 168;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.renderLowPowerOverlay(mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
    }

    private void renderLowPowerOverlay(int mouseX, int mouseY) {
        if (((AbstractBrowserContainer)this.func_212873_a_()).isLowOnPower()) {
            int l = this.field_147003_i + 7;
            int t = this.field_147009_r + 17;
            int w = 162;
            int h = 54;
            GlStateManager.disableDepthTest();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AbstractBrowserScreen.fill((int)l, (int)t, (int)(l + w), (int)(t + h), (int)0x7F000000);
            long tm = Minecraft.func_71410_x().field_71441_e.func_82737_E() % 30L;
            if (tm < 15L) {
                int n = l + w / 2;
                int n2 = t + h / 2;
                this.font.getClass();
                this.drawCenteredString(this.font, "NO POWER", n, n2 - 9 / 2, 0xFFFFFF);
            }
            GlStateManager.enableDepthTest();
        }
    }

    protected ResourceLocation getBackgroundTexture() {
        return backgroundTexture;
    }

    public void init() {
        super.init();
        this.sortModeButton = new Button(this.field_147003_i - 22, this.field_147009_r + 12, 20, 20, "", btn -> {
            SortMode mode = ((AbstractBrowserContainer)this.func_212873_a_()).sortMode;
            switch (mode) {
                case Alphabetic: {
                    mode = SortMode.StackSize;
                    break;
                }
                case StackSize: {
                    mode = SortMode.Alphabetic;
                }
            }
            this.changeSorting(mode);
        });
        this.addButton((Widget)this.sortModeButton);
        this.font.getClass();
        this.searchField = new TextFieldWidget(this.font, this.field_147003_i + 114, this.field_147009_r + 6, 71, 9, ""){

            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height) && mouseButton == 1 && !Strings.isNullOrEmpty((String)this.func_146179_b()) && this.func_146179_b().length() > 0) {
                    this.func_146180_a("");
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }
        };
        this.addButton((Widget)this.searchField);
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a(((AbstractBrowserContainer)this.func_212873_a_()).filterText);
        this.searchField.func_212954_a(this::updateSearchFilter);
        this.changeSorting(SortMode.StackSize);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (super.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return this.searchField.keyPressed(key, scanCode, modifiers);
    }

    private void updateSearchFilter(String text) {
        ((AbstractBrowserContainer)this.func_212873_a_()).setFilterText(text);
    }

    private void changeSorting(SortMode mode) {
        switch (mode) {
            case Alphabetic: {
                this.sortModeButton.setMessage("Az");
                break;
            }
            case StackSize: {
                this.sortModeButton.setMessage("#");
            }
        }
        ((AbstractBrowserContainer)this.func_212873_a_()).setSortMode(mode);
    }

    protected void func_146976_a(float partialTicks, int xMouse, int yMouse) {
        this.minecraft.func_110434_K().func_110577_a(this.getBackgroundTexture());
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.blit(this.field_147003_i - 27, this.field_147009_r + 8, 194, 0, 27, 28);
        this.minecraft.func_110434_K().func_110577_a(tabsTexture);
        boolean isEnabled = this.needsScrollBar();
        if (isEnabled) {
            this.blit(this.field_147003_i + 174, this.field_147009_r + 18 + this.scrollY, 232, 0, 12, 15);
        } else {
            this.blit(this.field_147003_i + 174, this.field_147009_r + 18, 244, 0, 12, 15);
        }
        this.searchField.render(xMouse, yMouse, partialTicks);
    }

    protected void func_146979_b(int xMouse, int yMouse) {
        RenderHelper.func_74520_c();
        this.drawCustomSlotTexts();
        RenderHelper.func_74518_a();
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    private void drawCustomSlotTexts() {
        for (int i = 0; i < 27; ++i) {
            Slot slot = (Slot)((AbstractBrowserContainer)this.func_212873_a_()).field_75151_b.get(i);
            this.drawSlotText(slot);
        }
    }

    private void drawSlotText(Slot slotIn) {
        int count;
        this.blitOffset = 100;
        int xPosition = slotIn.field_75223_e;
        int yPosition = slotIn.field_75221_f;
        ItemStack stack = slotIn.func_75211_c();
        if (stack.func_190916_E() > 0 && (count = ((AbstractBrowserContainer)this.func_212873_a_()).getClient().getStackSizeForSlot(slotIn.field_75222_d)) != 1) {
            String s = this.getSizeString(count);
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            GlStateManager.disableBlend();
            this.font.func_175063_a(s, (float)(xPosition + 19 - 2 - this.font.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
        }
        this.blitOffset = 0;
    }

    private String getSizeString(int count) {
        String s = count >= 1000000000 ? count / 1000000000 + "B" : (count >= 900000000 ? ".9B" : (count >= 1000000 ? count / 1000000 + "M" : (count >= 900000 ? ".9M" : (count >= 1000 ? count / 1000 + "k" : (count >= 900 ? ".9k" : String.valueOf(count))))));
        return s;
    }

    private boolean needsScrollBar() {
        int actualSlotCount = ((AbstractBrowserContainer)this.func_212873_a_()).getActualSlotCount();
        return actualSlotCount > 27;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheelDelta) {
        if (super.mouseScrolled(mouseX, mouseY, wheelDelta)) {
            return true;
        }
        this.scrollAcc = (float)((double)this.scrollAcc + wheelDelta * 120.0);
        int h = 62;
        int bitHeight = 15;
        int actualSlotCount = ((AbstractBrowserContainer)this.func_212873_a_()).getActualSlotCount();
        int rows = (int)Math.ceil((double)actualSlotCount / 9.0);
        if (rows > 3) {
            int scrollRows = rows - 3;
            int row = ((AbstractBrowserContainer)this.func_212873_a_()).scroll / 9;
            while (this.scrollAcc >= 120.0f) {
                --row;
                this.scrollAcc -= 120.0f;
            }
            while (this.scrollAcc <= -120.0f) {
                ++row;
                this.scrollAcc += 120.0f;
            }
            row = Math.max(0, Math.min(scrollRows, row));
            this.scrollY = row * 47 / scrollRows;
            ((AbstractBrowserContainer)this.func_212873_a_()).setScrollPos(row * 9);
        } else {
            this.scrollAcc = 0.0f;
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int w = 12;
        int h = 62;
        double mx = mouseX - 174.0 - (double)this.field_147003_i;
        double my = mouseY - 18.0 - (double)this.field_147009_r;
        if (mx >= 0.0 && mx < 12.0 && my >= 0.0 && my < 62.0) {
            this.updateScrollPos((int)my);
            this.isDragging = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void updateScrollPos(int my) {
        boolean isEnabled;
        int h = 62;
        int bitHeight = 15;
        int actualSlotCount = ((AbstractBrowserContainer)this.func_212873_a_()).getActualSlotCount();
        int rows = (int)Math.ceil((double)actualSlotCount / 9.0);
        int scrollRows = rows - 3;
        boolean bl = isEnabled = scrollRows > 0;
        if (isEnabled) {
            double offset = ((double)my - 7.5) * (double)scrollRows / 47.0;
            int row = Math.round(Math.max(0, Math.min(scrollRows, (int)offset)));
            this.scrollY = row * 47 / scrollRows;
            AbstractBrowserContainer container = (AbstractBrowserContainer)this.func_212873_a_();
            ((AbstractBrowserContainer)this.func_212873_a_()).setScrollPos(row * 9);
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        boolean ret = false;
        double my = mouseY - 18.0 - (double)this.field_147009_r;
        if (this.isDragging) {
            this.updateScrollPos((int)my);
            ret = true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, p_mouseDragged_6_, p_mouseDragged_8_) || ret;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        boolean ret = false;
        double my = mouseY - 18.0 - (double)this.field_147009_r;
        if (this.isDragging) {
            this.updateScrollPos((int)my);
            this.isDragging = false;
            ret = true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton) || ret;
    }
}

