/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.browser;

import com.google.common.collect.ImmutableMap;
import gigaherz.enderRift.automation.AggregatorBlock;
import gigaherz.enderRift.automation.browser.BrowserContainer;
import gigaherz.enderRift.automation.browser.BrowserTileEntity;
import gigaherz.enderRift.automation.browser.CraftingBrowserContainer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BrowserBlock
extends AggregatorBlock<BrowserTileEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public final boolean crafting;
    public static final VoxelShape NORTH_PANEL_PART = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_CENTER_PART1 = Block.func_208617_a((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)12.0);
    public static final VoxelShape NORTH_CENTER_PART2 = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0);
    public static final VoxelShape NORTH_PIPE_PART = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
    public static final VoxelShape SOUTH_PANEL_PART = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    public static final VoxelShape SOUTH_CENTER_PART1 = Block.func_208617_a((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)8.0);
    public static final VoxelShape SOUTH_CENTER_PART2 = Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SOUTH_PIPE_PART = Block.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape WEST_PANEL_PART = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_CENTER_PART1 = Block.func_208617_a((double)8.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
    public static final VoxelShape WEST_CENTER_PART2 = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    public static final VoxelShape WEST_PIPE_PART = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    public static final VoxelShape EAST_PANEL_PART = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_CENTER_PART1 = Block.func_208617_a((double)4.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0);
    public static final VoxelShape EAST_CENTER_PART2 = Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape EAST_PIPE_PART = Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape DOWN_PANEL_PART = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape DOWN_CENTER_PART1 = Block.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final VoxelShape DOWN_CENTER_PART2 = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final VoxelShape DOWN_PIPE_PART = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape UP_PANEL_PART = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape UP_CENTER_PART1 = Block.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    public static final VoxelShape UP_CENTER_PART2 = Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape UP_PIPE_PART = Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final ImmutableMap<Direction, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)Direction.WEST, (Object)VoxelShapes.func_216384_a((VoxelShape)WEST_CENTER_PART1, (VoxelShape[])new VoxelShape[]{WEST_CENTER_PART2, WEST_PANEL_PART, WEST_PIPE_PART})).put((Object)Direction.EAST, (Object)VoxelShapes.func_216384_a((VoxelShape)EAST_CENTER_PART1, (VoxelShape[])new VoxelShape[]{EAST_CENTER_PART2, EAST_PANEL_PART, EAST_PIPE_PART})).put((Object)Direction.SOUTH, (Object)VoxelShapes.func_216384_a((VoxelShape)SOUTH_CENTER_PART1, (VoxelShape[])new VoxelShape[]{SOUTH_CENTER_PART2, SOUTH_PANEL_PART, SOUTH_PIPE_PART})).put((Object)Direction.NORTH, (Object)VoxelShapes.func_216384_a((VoxelShape)NORTH_CENTER_PART1, (VoxelShape[])new VoxelShape[]{NORTH_CENTER_PART2, NORTH_PANEL_PART, NORTH_PIPE_PART})).put((Object)Direction.DOWN, (Object)VoxelShapes.func_216384_a((VoxelShape)DOWN_CENTER_PART1, (VoxelShape[])new VoxelShape[]{DOWN_CENTER_PART2, DOWN_PANEL_PART, DOWN_PIPE_PART})).put((Object)Direction.UP, (Object)VoxelShapes.func_216384_a((VoxelShape)UP_CENTER_PART1, (VoxelShape[])new VoxelShape[]{UP_CENTER_PART2, UP_PANEL_PART, UP_PIPE_PART})).build();

    public BrowserBlock(boolean crafting, Block.Properties properties) {
        super(properties);
        this.crafting = crafting;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BrowserTileEntity();
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return (VoxelShape)SHAPES.get((Object)state.func_177229_b((IProperty)FACING));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l().func_176734_d());
    }

    @Deprecated
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof BrowserTileEntity) || player.func_70093_af()) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.crafting) {
            this.openCraftingBrowser(player, (BrowserTileEntity)tileEntity);
        } else {
            this.openBrowser(player, (BrowserTileEntity)tileEntity);
        }
        return true;
    }

    private void openBrowser(PlayerEntity player, BrowserTileEntity tileEntity) {
        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new BrowserContainer(id, tileEntity, playerInventory), (ITextComponent)new TranslationTextComponent("container.enderrift.browser", new Object[0])));
    }

    private void openCraftingBrowser(PlayerEntity player, BrowserTileEntity tileEntity) {
        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new CraftingBrowserContainer(id, tileEntity, playerInventory), (ITextComponent)new TranslationTextComponent("container.enderrift.crafting_browser", new Object[0])));
    }
}

